/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pangu.rta.common.xinyi;

import com.bxm.pangu.rta.common.AbstractHttpClientRtaClient;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.RtaType;
import com.bxm.pangu.rta.common.xinyi.XinyiRtaProperties;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XinyiRtaClient
extends AbstractHttpClientRtaClient {
    private static final Logger log = LoggerFactory.getLogger(XinyiRtaClient.class);

    public XinyiRtaClient(XinyiRtaProperties properties) {
        super(properties);
    }

    @Override
    protected HttpRequestBase create(RtaRequest request) {
        String param = Optional.ofNullable(request.getParam()).orElse("");
        String[] split = StringUtils.split((String)param, (String)"|");
        if (split.length != 2) {
            throw new IllegalArgumentException("param");
        }
        String token = split[0];
        String tasks = split[1];
        List<String> taskList = Arrays.asList(tasks.split(","));
        if (CollectionUtils.isEmpty(taskList)) {
            throw new IllegalArgumentException("xinyi tasks cannot be empty");
        }
        String url = this.getProperties().getUrl();
        url = StringUtils.replace((String)url, (String)"{token}", (String)token);
        String type = "";
        String id = "";
        if (StringUtils.equals((String)request.getOs(), (String)"android")) {
            if (StringUtils.isNotBlank((String)request.getOaid())) {
                type = "oaid";
                id = request.getOaid();
            } else if (StringUtils.isNotBlank((String)request.getOaid_md5())) {
                type = "oaid_md5";
                id = request.getOaid_md5();
            } else if (StringUtils.isNotBlank((String)request.getImei())) {
                type = "imei";
                id = request.getImei();
            } else if (StringUtils.isNotBlank((String)request.getImei_md5())) {
                type = "imei_md5";
                id = request.getImei_md5();
            }
        } else if (StringUtils.equals((String)request.getOs(), (String)"ios")) {
            if (StringUtils.isNotBlank((String)request.getIdfa())) {
                type = "idfa";
                id = request.getIdfa();
            } else if (StringUtils.isNotBlank((String)request.getIdfa_md5())) {
                type = "idfa_md5";
                id = request.getIdfa_md5();
            }
        }
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", type);
        paramMap.put("id", id);
        paramMap.put("tasks", taskList);
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert(paramMap), StandardCharsets.UTF_8));
        return post;
    }

    @Override
    protected boolean isTarget(RtaRequest request, String json) {
        String param;
        String[] split;
        XinyiResponse xinyiResponse = (XinyiResponse)JsonHelper.convert((String)json, XinyiResponse.class);
        List<String> responseTasks = xinyiResponse.getTasks();
        if (CollectionUtils.isNotEmpty(responseTasks) && (split = StringUtils.split((String)(param = request.getParam()), (String)"|")).length == 2) {
            String tasks = split[1];
            ArrayList taskList = Lists.newArrayList();
            taskList.addAll(Arrays.asList(tasks.split(",")));
            taskList.retainAll(responseTasks);
            if (CollectionUtils.isNotEmpty((Collection)taskList)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public RtaType getRtaType() {
        return RtaType.Xinyi;
    }

    private static class XinyiResponse {
        private List<String> tasks;

        public List<String> getTasks() {
            return this.tasks;
        }

        public void setTasks(List<String> tasks) {
            this.tasks = tasks;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XinyiResponse)) {
                return false;
            }
            XinyiResponse other = (XinyiResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$tasks = this.getTasks();
            List<String> other$tasks = other.getTasks();
            return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XinyiResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $tasks = this.getTasks();
            result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
            return result;
        }

        public String toString() {
            return "XinyiRtaClient.XinyiResponse(tasks=" + this.getTasks() + ")";
        }
    }
}

