package com.bxm.pay.facade;

import com.bxm.pay.facade.constants.ServiceNameConstants;
import com.bxm.pay.facade.model.OrderCallbackResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/10/15 10:39
 */
@FeignClient(name = ServiceNameConstants.PAY_SERVICE)
public interface NotifyService {

    /**
     * 阿里回调 支付和退款统一
     * @param result
     */
    @RequestMapping("/alipay/notify")
    void aliNotify(@RequestBody OrderCallbackResult result);

    /**
     * 微信退款回调
     * @param result
     * @return
     * @throws Exception
     */
    @RequestMapping("/wxPay/refund/notify")
    String wxRefundNotify(@RequestBody OrderCallbackResult result) throws Exception;

    /**
     * 微信支付回调
     * @param result
     * @return
     * @throws Exception
     */
    @RequestMapping("/wxPay/notify")
    String wxPayNotify(@RequestBody OrderCallbackResult result) throws Exception;


    /**
     * @deprecated 这个方法存在BUG，如果相同渠道配置多个，且使用不同的wxKey时，会导致回调签名错误。请使用 {@link PayConfigFacadeService} 服务。
     */
    @Deprecated
    @RequestMapping("/findPk")
    public String pk(@RequestParam("bid") String bid);

    /**
     * @deprecated 这个方法存在BUG，如果相同渠道配置多个，且使用不同的wxKey时，会导致回调签名错误。请使用 {@link PayConfigFacadeService} 服务。
     */
    @Deprecated
    @RequestMapping("/findWxKey")
    public String wxKey(@RequestParam("bid") String bid);
}
