package com.bxm.pay.facade;

import com.bxm.pay.facade.constants.ServiceNameConstants;
import com.bxm.pay.facade.model.PayConfigDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author huxiao
 * @date 2024/5/9
 * @since 1.0.0
 */
@FeignClient(name = ServiceNameConstants.PAY_SERVICE)
public interface PayConfigFacadeService {

    /**
     * 根据订单号查询支付的配置
     *
     * @param orderId 订单号
     * @return 支付配置
     */
    @PostMapping("/payConfigService/queryByOrderId")
    PayConfigDto queryByOrderId(@RequestBody String orderId);
}
