package com.bxm.pay.facade;

import com.bxm.pay.facade.constants.ServiceNameConstants;
import com.bxm.pay.facade.model.Order;
import com.bxm.pay.facade.model.RefundResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/10/15 10:49
 */
@FeignClient(name = ServiceNameConstants.PAY_SERVICE)
public interface PayService {

    /**
     * 支付渠道 payType 1：微信，2:支付宝
     * 支付环境 clientType，0：h5，1：app，2：微信，3：QQ, 4:PC , 5:支付宝
     * 业务 business 1：征信
     * 支付完成通知地址： notifyUrl
     * @param order
     * @return
     */
    @RequestMapping("/pay")
    public String pay(@RequestBody Order order);


    /**
     * 关闭
     * @param order
     * @return
     */
    @RequestMapping("/close")
    public void close(@RequestBody Order order);

    /**
     * 查询交易状态
     * @param order
     * @return
     */
    @RequestMapping("/query")
    public void query(@RequestBody Order order);

    /**
     * 退款
     * @param order payType，business，orderNum，amount 必填参数
     * @return RefundResult
     */
    @RequestMapping("/refund")
    public RefundResult refund(@RequestBody Order order);

    /**
     * 退款状态
     * @param order
     * @return
     */
    @RequestMapping("/refundQuery")
    public void refundQuery(@RequestBody Order order);

}
