package com.bxm.pay.facade;

import com.bxm.pay.facade.constants.ServiceNameConstants;
import com.bxm.pay.facade.model.TransferDTO;
import com.bxm.pay.facade.model.TransferOrderBean;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 转账服务
 * author:tangxiao
 */
@FeignClient(name = ServiceNameConstants.PAY_SERVICE)
public interface TransferService {

    /**
     * 单笔转账
     * @param transferDTO
     * @return
     */
    @RequestMapping("/transfer")
    String transfer(@RequestBody TransferDTO transferDTO);

    /**
     * 公司账户余额查询
     * @return
     */
    @RequestMapping("/queryAccount")
    String queryAccount();

    @RequestMapping("/getOrderListByTime")
    List<TransferOrderBean> getOrderListFromDb(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);

    /**
     * 查询一段时间内  脚本执行转账有效人数   （具有单一业务特性  不具备通用性）
     * @param startTime
     * @param endTime
     * @return
     */
    @RequestMapping("/transferCount")
    Integer transferCount(@RequestParam("startTime") String startTime, @RequestParam("endTime") String endTime);
}
