package com.bxm.pay.facade.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author huxiao
 * @date 2024/5/9
 * @since 1.0.0
 */
@Data
@Accessors(chain = true)
public class PayConfigDto {

    private Integer id;

    /**
     * 支付渠道名称
     */
    private String channelName;

    /**
     * 支付渠道账号
     */
    private String channelAccount;

    /**
     * 支付渠道，1支付宝支付，2微信支付
     */
    private Byte payType;

    /**
     * 支付通道状态，0禁用，1启用
     */
    private Byte channelStatus;

    /**
     * 私钥
     */
    private String privateKey;

    /**
     * 公钥
     */
    private String publicKey;

    /**
     * 客户端类型，0：h5，1：app，2：微信，3：QQ，4：其他
     */
    private Byte clientType;

    /**
     * 微信appid
     */
    private String wxAppid;

    /**
     * 微信支付key
     */
    private String wxKey;

    /**
     * 证书文件名
     */
    private String certName;
}
