package com.bxm.pay.facade.model;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/6 15:13
 */
public class RefundResult {

    public static final String SUCCESS = "10000";
    /**
     * code=10000 代表成功，其它都是失败
     */
    private String code;
    /**
     * msg 结果说明
     */
    private String msg;

    public RefundResult(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }


    public RefundResult() {
    }

    public static RefundResult success(String msg){
        return new RefundResult(SUCCESS,msg);
    }

    public static RefundResult error(String msg){
        return new RefundResult("-1",msg);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getMsg() {
        return msg;
    }

    public boolean isSuccess() {
        return SUCCESS.equals(code);
    }
}
