/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.pay.facade.enums;

import com.google.common.collect.Lists;
import java.util.List;

public enum OrderStatusEnum {
    WAIT_PAY((byte)0, "\u5f85\u652f\u4ed8", Lists.newArrayList((Object[])new Byte[]{(byte)3, (byte)1})),
    CLOSE_PAY((byte)3, "\u5173\u95ed\u652f\u4ed8", Lists.newArrayList()),
    SUCCESS_PAY((byte)1, "\u5df2\u652f\u4ed8", Lists.newArrayList((Object[])new Byte[]{(byte)7})),
    REFUNDING((byte)7, "\u9000\u6b3e\u4e2d", Lists.newArrayList((Object[])new Byte[]{(byte)6, (byte)8, (byte)7})),
    SUCCESS_REFUND((byte)6, "\u9000\u6b3e\u5b8c\u6210", Lists.newArrayList()),
    FAIL_REFUND((byte)8, "\u9000\u6b3e\u5931\u8d25", Lists.newArrayList((Object[])new Byte[]{(byte)7}));

    private final Byte status;
    private final String desc;
    private final List<Byte> nextStatusList;

    public static boolean allowStatusChange(Byte current, Byte next) {
        for (OrderStatusEnum x : OrderStatusEnum.values()) {
            if (!x.status.equals(current)) continue;
            return x.nextStatusList.contains(next);
        }
        return false;
    }

    public Byte getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public List<Byte> getNextStatusList() {
        return this.nextStatusList;
    }

    private OrderStatusEnum(Byte status, String desc, List<Byte> nextStatusList) {
        this.status = status;
        this.desc = desc;
        this.nextStatusList = nextStatusList;
    }
}

