/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.profit.facade;

import java.util.List;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.profit.model.dto.AdIncomeLogDto;
import com.bxm.profit.model.dto.AddAdIncomeLogDto;
import com.bxm.profit.model.dto.IncomeLogDto;
import com.bxm.profit.model.vo.AdIncomeLogVo;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;

/**
 * @ClassName AdIncomeService.java
 * @Description 功能描述：
 * @author leon 2018年3月20日 下午4:18:52
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "profit")
public interface AdIncomeService {

    /**
     * @Description 方法描述：新增广告收益（根据媒体）
     * @author leon 2018年3月20日 下午4:53:25
     * @CopyRight 杭州微财网络科技有限公司
     * @param incomeLogDto
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/", method = RequestMethod.POST)
    public ResultModel<Boolean> add(@RequestBody IncomeLogDto incomeLogDto) throws ValidateException, Exception;

    /**
     * @Description 方法描述：新增广告收益（根据广告位）
     * @author leon 2018年3月20日 下午4:53:25
     * @CopyRight 杭州微财网络科技有限公司
     * @param addAdIncomeLogDto
     * @return
     * @throws ValidateException
     * @throws Exception
     */
    @RequestMapping(value = "/adIncomeLog/add", method = RequestMethod.POST)
    public ResultModel<Boolean> add(@RequestBody AddAdIncomeLogDto addAdIncomeLogDto) throws ValidateException,
                                                                                      Exception;

    /**
     * @Description 方法描述：根据条件查询列表
     * @author leon 2018年3月20日 下午4:53:40
     * @CopyRight 杭州微财网络科技有限公司
     * @param adIncomeLogDto
     * @return
     */
    @RequestMapping(value = "/adIncomeLog/getList", method = RequestMethod.GET)
    public ResultModel<List<AdIncomeLogVo>> getList(AdIncomeLogDto adIncomeLogDto);

}
