package com.bxm.promotion.facade.model;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * app用户行为模型
 * @author weixing
 */
@Data
public class UserActionModel implements Serializable {
    private static final long serialVersionUID = 1245567173561341L;

    /**
     * 退款
     */
    public static final Integer REFUND = -1;

    /**
     * 注册
     */
    public static final Integer REGISTER = 1;

    /**
     * 消费
     */
    public static final Integer CONSUME = 2;

    /**
     * 激活
     */
    public static final Integer ACTIVATION = 3;

    /**
     * 婚姻认证
     */
    public static final Integer MARRIAGE= 4;

    /**
     * 学历认证
     */
    public static final Integer EDUCATION = 5;

    /**
     * 用户资料完善>=80%
     */
    public static final Integer INFO_COMPLETE = 6;

    @NotNull(message = "用户ID不能为空")
    private  Long userId;

    @NotNull(message = "用户unionId不能为空")
    private String unionId;

    /**
     * 类型 -1-充值 1-注册 2-消费 3-激活 4-婚姻认证 5-学历认证 6-用户资料完善
     */
    @NotNull(message = "类型不能为空")
    private Integer type;

    /**
     * 充值或者消费订单
     */
    private String orderNum;

    /**
     * 订单金额
     */
    private BigDecimal amount;

    /**
     * 区 code（注册时的定位/ip,不是用户填写的）
     */
    private Integer districtCode;

    /**
     * 学历  2高中及以下、4大专、8大学本科、16硕士、32博士
     */
    private Integer eduHighest;

    /**
     * 婚姻 2未婚、4离异、8丧偶
     */
    private Integer marriage;
}
