package com.bxm.shop.dal;

import com.bxm.shop.dal.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Table;

/**
 * 助力发起dao
 * @author yirenjie
 * createDate:  2018/12/20
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Table(name = "tbl_boost")
public class Boost extends BaseEntity {
    private String openid;  // 微信openid
    private Status status;  // 状态
    private String goodsName;  // 商品名称
    private Long goodsPrice;  // 商品价格,单位分
    private String goodsImageUrl;  // 图片地址
    private Integer requiredAmount;  // 要求的助力者数量

    public enum Status{
        I,  // 初始状态
        H,  // 助力中,当第一个人开始助力时
        S,  // 助力成功
        F,  // 助力失败
        U;  // 助力0元购机会已使用
        public boolean isBoosting(){
            return this == I || this == H;
        }
    }
}
