package com.bxm.shop.dal.mapper;

import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.model.friend.vo.OpenidAndAmount;
import com.bxm.shop.model.goods.vo.GoodsCount;
import com.bxm.shop.model.order.dao.OrderDao;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

public interface OrderMapper {

    int save(OrderDao order);

    int update(OrderDao order);

    List<OrderDao> query(OrderDto dto);

    OrderDao findById(@Param("id") Long id);

    int deleteAbandonOrder(@Param("date") Date date);

    /**
     * 统计商品数量
     * @param soldState
     * @return
     */
    List<GoodsCount> statisticsSoldGoodsNum(@Param("soldState") Integer[] soldState);

    /**
     * 查询数量
     * @param dto
     * @return
     */
    Long totalCount(OrderDto dto);

    List<OpenidAndAmount> findUserOrderAmount(@Param("openids")List<String> openids, @Param("soldState") Integer[] soldState);

    /**
     * 最新生成的订单数量
     * @param openid
     * @param date
     * @return
     */
    Long lastGenerateOrder(@Param("openid")String openid, @Param("date") Date date);

}
