package com.bxm.shop.dal.mapper;

import com.bxm.shop.model.friend.vo.FriendCount;
import com.bxm.shop.model.user.dao.UserDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 * 用户信息Dapper
 * @author baocc
 *
 */
public interface UserMapper {

    int save(UserDao user);

    int updateByOpenid(UserDao user);

    UserDao findByOpenid(@Param("openid") String openid);

    UserDao findByInviteCode(@Param("inviteCode") String inviteCode);

    /**
     * 统计我的直接好友数量
     * @param openid
     * @return
     */
    Integer countDirectFriendNum(@Param("openid") String openid);

    /**
     * 统计我的间接好友数量
     * @param openid
     * @return
     */
    Integer countIndirectFriendNum(@Param("openid") String openid);

    /**
     * 获取直接好友信息
     * @param openids
     * @return
     */
    List<UserDao> findDirectFriendInfo(@Param("openid") String openid);

    /**
     * 获取间接好友信息
     * @param openids
     * @return
     */
    List<UserDao> findIndirectFriendInfo(@Param("openid") String openid);

    /**
     * 统计直接好友的好友数量
     * @param openids
     * @return
     */
    List<FriendCount> getFriendCount(@Param("openids") List<String> openids);
}
