package com.bxm.shop.dal.mapper;

import com.bxm.shop.model.friend.vo.OpenidAndAmount;
import com.bxm.shop.model.profit.dao.UserProfitDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface UserProfitMapper {

    int save(UserProfitDao profit);

    int updateStatusByOrderIdAndType(@Param("orderId") Long orderId,@Param("orderStatus")Integer orderStatus,@Param("profitType")String profitType);

    UserProfitDao findByOrderIdAndType(@Param("orderId") Long orderId,@Param("profitType")String profitType);

    Long friendContributeAmount(@Param("openid")String openid,@Param("soldState") Integer[] soldState);

    List<OpenidAndAmount> findDirectFriendContributeAmount(@Param("openid")String openid,@Param("soldState") Integer[] soldState);

    List<OpenidAndAmount> findIndirectFriendContributeAmount(@Param("openid")String openid,@Param("soldState") Integer[] soldState);

    /**
     * 统计用户不同状态的金额
     * @param openid
     * @param states
     * @return
     */
    Long getAmountByOpenidAndStates(@Param("openid")String openid,@Param("states") Integer[] states);
}
