package com.bxm.shop.facade;

import com.bxm.shop.facade.model.common.CommonDto;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 好友关系相关service
 */
@FeignClient(name="shops-service")
public interface FriendService {

    @RequestMapping(value = "/friend/info", method = RequestMethod.POST)
    ResultModel info(@RequestBody CommonDto dto);

    @RequestMapping(value = "/friend/findDirectFriends", method = RequestMethod.POST)
    ResultModel findDirectFriends(@RequestBody CommonDto dto);

    @RequestMapping(value = "/friend/findIndirectFriends", method = RequestMethod.POST)
    ResultModel findIndirectFriends(@RequestBody CommonDto dto);

}
