package com.bxm.shop.facade;

import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 订单相关serice
 */
@FeignClient(name="shops-service")
public interface OrderService {

    @RequestMapping(value = "/order/add", method = { RequestMethod.POST})
    ResultModel add(@RequestBody OrderDto dto);

    @RequestMapping(value = "/order/deleteAbandonOrder", method = { RequestMethod.POST})
    ResultModel deleteAbandonOrder(@RequestBody OrderDto dto);

    @RequestMapping(value = "/order/synchronizeOrder", method = { RequestMethod.POST})
    ResultModel synchronizeOrder(@RequestBody OrderDto dto);

    @RequestMapping(value = "/order/statisticsSoldGoodsNum", method = { RequestMethod.POST})
    ResultModel statisticsSoldGoodsNum(@RequestBody List<String> goodsId);

    @RequestMapping(value = "/order/find", method = { RequestMethod.POST})
    ResultModel find(@RequestBody OrderDto dto);
}
