package com.bxm.shop.facade;

import com.bxm.shop.facade.model.user.UserDto;
import com.bxm.shop.facade.model.user.UserVo;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户相关serice
 */
@FeignClient(name="shops-service")
public interface UserService {

    @RequestMapping(value = "/user/login", method = { RequestMethod.POST})
    ResultModel login(@RequestBody UserDto dto);

    @RequestMapping(value = "/user/update", method = { RequestMethod.POST})
    ResultModel update(@RequestBody UserDto dto);
}
