package com.bxm.shop.facade;

import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.facade.model.wallet.WalletDto;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name="shops-service")
public interface WalletService {

    @RequestMapping(value = "/wallet/withdraw", method = { RequestMethod.POST})
    ResultModel withdraw(@RequestBody WalletDto dto);

    @RequestMapping(value = "/wallet/info", method = { RequestMethod.POST})
    ResultModel info(@RequestBody WalletDto dto);

    @RequestMapping(value = "/wallet/payRetry", method = { RequestMethod.POST})
    ResultModel payRetry();
}
