package com.bxm.shop.facade.model.common;

import com.bxm.shop.facade.annotations.HeadParamOpenid;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

@Getter
@Setter
@ToString
public class CommonDto implements Serializable {

    @NotBlank(message = "openid不能为空", groups = { CommonDto.Common.class ,CommonDto.Openid.class ,CommonDto.Order.class })
    protected String openid;

    @NotBlank(message = "商品Id不能为空", groups = { CommonDto.Common.class })
    protected String goodsId;

    protected Integer pageStart;

    /**
     * 页码，从1开始
     */
    protected Integer pageNum;

    /**
     * 每页条数
     */
    protected Integer pageSize;

    public interface Common{}

    public interface Openid{}

    public interface Order{}
}
