package com.bxm.shop.facade.model.order;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@ToString
public class PddOrderInfo implements Serializable {

    /**
     * 多多客工具ID
     */
    private Long authDuoId;

    /**
     * 结算批次号
     */
    private String batchNo;

    /**
     * 自定义参数
     */
    private String customParameters;

    /**
     * 多多券金额
     */
    private Integer duoCouponAmount;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * 商品名
     */
    private String goodsName;

    /**
     * 商品价格（分）
     */
    private Long goodsPrice;

    /**
     * 商品数量
     */
    private Integer goodsQuantity;

    /**
     * 商品缩略图
     */
    private String goodsThumbnailUrl;

    /**
     * 成团编号
     */
    private Long groupId;

    /**
     * 订单来源 ：0 ：关联，5 ：直接下单页RPC请求
     */
    private Integer matchChannel;

    /**
     * 订单价格（分）
     */
    private Long orderAmount;

    /**
     * 订单创建时间
     */
    private Long orderCreateTime;

    /**
     * 订单成团时间（UNIX时间戳）
     */
    private Long orderGroupSuccessTime;

    /**
     * 订单最后更新时间
     */
    private Long orderModifyAt;

    /**
     * 订单支付时间（UNIX时间戳）
     */
    private Long orderPayTime;

    /**
     * 订单确认收货时间（UNIX时间戳）
     */
    private Long orderReceiveTime;

    /**
     * 订单结算时间（UNIX时间戳）
     */
    private Long orderSettleTime;

    /**
     * 拼多多订单编号
     */
    private String orderSn;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 订单状态描述
     * （ -1 未支付; 0-已支付；1-已成团；2-确认收货；3-审核成功；4-审核失败（不可提现）；
     *  5-已经结算；8-非多多进宝商品（无佣金订单）;10-已处罚）
     */
    private String orderStatusDesc;

    /**
     * 订单审核时间（UNIX时间戳）
     */
    private Long orderVerifyTime;

    /**
     * 推广位ID
     */
    private String pid;

    /**
     * 佣金（分）
     */
    private Long promotionAmount;

    /**
     * 佣金比例 千分比
     */
    private Long promotionRate;

    /**
     * 订单类型：0：领券页面， 1： 红包页， 2：领券页， 3： 题页
     */
    private Integer type;


    /**
     * 招商多多客ID
     */
    private Long zsDuoId;

    /**
     * cpsSign 拼多多返回字段
     */
    private String cpsSign;

    /**
     * 链接最后一次生产时间
     */
    private String urlLastGenerateTime;

    /**
     * 打点时间
     */
    private Long pointTime;

    /**
     * 售后状态：0：无，1：售后中，2：售后完成
     */
    private Integer returnStatus;

    /**
     * 接口文档中没该字段，接口返回
     */
    private Long verifyTime;
}
