package com.bxm.shop.facade.model.tag;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author yirenjie
 * createDate:  2018/11/12
 */
@NoArgsConstructor
@Data
public class TagsVo implements Serializable {

    private List<TagVo> tags;


    @NoArgsConstructor
    @Data
    public static class DetailDataBean {
        private String key;
        private int optID;
        private int optType;
        private boolean showAll;
        private int defaultChildNum;
        private String tabName;
        private int priority;
        private String listItemName;
        private StyleConfigBeanX styleConfig;
        private List<CatBean> cat;
        private List<BannerListBean> bannerList;
        private List<?> brands;

        @NoArgsConstructor
        @Data
        public static class StyleConfigBeanX {
            private String selectedBgURL;
            private String unSelectedBgURL;
            private String selectedColor;
            private String unSelectedColor;
            private String bannerURL;
            private String titleColor;
            private String viewAllColor;
        }

        @NoArgsConstructor
        @Data
        public static class CatBean {
            private String key;
            private Long optID;
            private int optType;
            private String optName;
            private int priority;
            private boolean isHightlight;
            private String imgUrl;
        }

        @NoArgsConstructor
        @Data
        public static class BannerListBean {
            private int optionID;
            private String imgUrl;
            private String linkUrl;
        }
    }
}
