package com.bxm.shop.facade.model.user;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 用户信息dto
 * @author bcc
 */
@Getter
@Setter
@ToString
public class UserDto implements Serializable {

    @NotBlank(message = "code不能为空", groups = { UserDto.Code.class })
    private String code;

    @NotBlank(message = "openid不能为空", groups = { UserDto.Openid.class })
    private String openid;

    /**
     * 头像url
     */
    private String avatar;

    private String nickname;

    /**
     * 性别
     */
    private Integer gender;

    private String inviteCode;

    private String mobile;

    public interface Code{}

    public interface Openid{}
}
