package com.bxm.shop.facade.model.wallet;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import java.io.Serializable;

/**
 * 钱包查询对象
 * @author  BCC
 */
@Getter
@Setter
public class WalletDto  implements Serializable {

    @NotBlank(message = "openid不能为空", groups = { WalletDto.Withdraw.class,WalletDto.Openid.class })
    private String openid;

    @NotBlank(message = "token不能为空", groups = { WalletDto.Withdraw.class })
    private String token;

    @Min(value=100 ,message = "参数不正确", groups = { WalletDto.Withdraw.class })
    private Long amount;

    public interface Withdraw{}

    public interface Openid{}

}
