package com.bxm.shop.integration.pdd;


import com.bxm.shop.facade.model.GoodsQueryRo;
import com.bxm.shop.model.Good;
import com.bxm.shop.model.GoodDetail;
import com.bxm.shop.model.GoodsList;

import java.util.List;

/**
 * 拼多多商品相关api
 * @author yirenjie
 * createDate:  2018/11/8
 */
public interface PddGoodsIntegration {

    /**
     * 查询商品列表
     * @param goodsQueryRo 查询条件
     */
    GoodsList.GoodsSearchResponse queryGoodsList(GoodsQueryRo goodsQueryRo);

    /**
     * 查询商品列表
     * @param goodsIdList 商品id集合
     */
    List<Good> queryGoodsList(List<String> goodsIdList);

    /**
     * 商品详情查询
     * @param goodId 商品id
     * @return
     */
    GoodDetail queryGoodDetail(String goodId);

}
