package com.bxm.shop.integration.pdd.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.shop.common.constants.PingduoduoConstant;
import com.bxm.shop.common.utils.JSONStringUnderscoreToCamel;
import com.bxm.shop.common.utils.OkHttpUtils;
import com.bxm.shop.common.utils.ParamEncodeUtils;
import com.bxm.shop.facade.model.order.OrderDto;
import com.bxm.shop.facade.model.order.OrderVo;
import com.bxm.shop.facade.model.order.PddOrderInfo;
import com.bxm.shop.facade.model.order.PddOrderList;
import com.bxm.shop.integration.config.PddConstants;
import com.bxm.shop.integration.config.PingduoduoConfig;
import com.bxm.shop.integration.pdd.OrderIncrementGetIntegration;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import static com.bxm.shop.common.utils.ParamEncodeUtils.unicodeToString;

@Component
@Slf4j
public class OrderIncrementGetIntegrationImpl implements OrderIncrementGetIntegration {

    @Autowired
    private PingduoduoConfig pingduoduoConfig;

    @Override
    public PddOrderList getIncrementOrder(OrderDto dto) {
        Map<String,String> param = pingduoduoConfig.getCommonParam();
        param.put(PingduoduoConstant.Param.TYPE, PddConstants.ORDER_INCREMENT_GET);
        param.put(PingduoduoConstant.Param.START_UPDATE_TIME,dto.getStartUpdateTime()+"");
        param.put(PingduoduoConstant.Param.END_UPDATE_TIME,dto.getEndUpdateTime()+"");
        param.put(PingduoduoConstant.Param.PAGE,dto.getPageNum()+"");
        param.put(PingduoduoConstant.Param.PAGE_SIZE,dto.getPageSize()+"");
        String sign = ParamEncodeUtils.getMd5Signature(param, pingduoduoConfig.getClientSecret());
        param.put(PingduoduoConstant.Param.SIGN,sign);
        String response = null;
        try {
            response = OkHttpUtils.post(PddConstants.URL, param);
            response = unicodeToString(response);
            System.out.println(response);
            if(null != response) {
                JSONObject obj = JSON.parseObject(response);
                if(null != obj && obj.getString("order_list_get_response") != null){
                    String orderInfo = JSONStringUnderscoreToCamel.transform(obj.getString("order_list_get_response"));
                    return JSON.parseObject(orderInfo,PddOrderList.class);
                }
            }
        } catch (IOException e) {
            log.error("CommonDoodsPromotionUrlIntegrationImpl.generate  Error",e);
        }
        return null;
    }
}
