/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.shopmanager.timer.jobs;

import com.bxm.shop.facade.GoodsService;
import com.bxm.shop.facade.model.GoodVo;
import com.bxm.shopmanager.dal.mapper.GoodsMapper;
import com.bxm.shopmanager.dal.mapper.GoodsPoolMapper;
import com.bxm.shopmanager.model.dao.Goods;
import com.bxm.shopmanager.timer.Job;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class GoodsUpdateJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoodsUpdateJob.class);
    @Autowired
    private GoodsService goodsService;
    @Autowired
    private GoodsMapper goodsMapper;
    @Autowired
    private GoodsPoolMapper goodsPoolMapper;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Override
    @Scheduled(cron="0 0/5 * * * ? ")
    public void execute() {
        List allGoodsId;
        long start = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting  GoodsUpdateJob...");
        }
        if (CollectionUtils.isNotEmpty((Collection)(allGoodsId = this.goodsMapper.findAllGoodsId()))) {
            List returnValue = (List)this.goodsService.queryGoodListByIds(allGoodsId).getReturnValue();
            HashMap<String, String> map = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty((Collection)returnValue)) {
                for (GoodVo goodVo : returnValue) {
                    map.put(goodVo.getGoodsId(), goodVo.getGoodsName());
                }
            }
            ArrayList goodsList = Lists.newArrayList();
            for (String s : allGoodsId) {
                Goods goods = new Goods();
                goods.setId(s);
                String e = map.getOrDefault(s, null);
                if (e != null) {
                    goods.setGoodsName(e);
                    goods.setIsOnSale(Byte.valueOf((byte)1));
                } else {
                    goods.setIsOnSale(Byte.valueOf((byte)0));
                }
                goodsList.add(goods);
            }
            this.goodsMapper.updateByList((List)goodsList);
            LOGGER.info("\u6267\u884c\u5b8c\u66f4\u65b0");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("GoodsUpdateJob finished in {} ms!", (Object)(System.currentTimeMillis() - start));
        }
    }
}

