package com.bxm.shopmanager.facade.service;

import com.bxm.shopmanager.facade.model.GoodsPoolDTO;
import com.bxm.shopmanager.facade.model.RebateDTO;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;
import java.util.Map;

/**
 * Created by wuwenquan on 2018/12/21.
 */
@FeignClient(name = "shops-web")
public interface ConfigService {
    @RequestMapping(value = "/goodsPool/getGoodsPoolByIds", method = RequestMethod.POST)
    ResultModel<Map<Long,GoodsPoolDTO>> getGoodsPoolByIds(@RequestBody List<Long> ids);

    @RequestMapping(value = "/rebate/getRebateByIds", method = RequestMethod.POST)
    ResultModel<Map<String,RebateDTO>> getRebateByIds(@RequestBody List<String> ids);
}
