package com.bxm.spider.deal.common.constant;

/**
 * <p> 规则相关常量 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/10/17
 */
public class RulerConstant {
    /**
     * 规则类型：列表url
     */
    public static final int RULER_TYPE_URL_LIST = 1;
    /**
     * 规则类型：详情url
     */
    public static final int RULER_TYPE_URL_DETAIL = 2;
    /**
     * 下一页url用当前url的标记
     */
    public static final String RULER_NEXT_URL_FLAG = "0";
    /**
     * 规则类型：要爬去的内容字段
     */
    public static final int RULER_TYPE_CONTENT = 3;
    /**
     * 频道
     */
    public static final String CHANNEL = "channel";
    /**
     * 规则名称
     */
    public static final String KEYWORD = "keyword";
    /**
     * 标题
     */
    public static final String TITLE = "title";
    /**
     * 内容
     */
    public static final String CONTENT = "content";
    /**
     * 多个图片 url 分割符
     */
    public static final String IMG_URL_SPLIT = ";";
    /**
     * 下一页列表url 规则
     */
    public static final String URL_NEXT_LIST = "url_next_list";
    /**
     * 当前页详情url 规则
     */
    public static final String URL_DETAIL = "url_detail";
    /**
     * 详情页下一页url
     */
    public static final String DETAIL_NEXT_URL = "detail_next_url";
    /**
     * 列表url 规则
     */
    public static final String URL_LIST  = "url_list";
    /**
     * 详情页预处理 规则
     */
    public static final String DETAILS_PREPROCCESS  = "details_preprocess";

    public static final String TIME_PATTER = "yyyy-MM-dd HH:mm:ss";
    /**
     * 可否为空：不可为空
     */
    public static final int EMPTY_FLAG_IS = 1;
    /**
     * 可否为空：可为空
     */
    public static final int EMPTY_FLAG_NOT = 0;
    /**
     * 内容条件：多个替换内容分隔符
     */
    public static final String REPLACE_MORE_SPLIT = "_:_";
    /**
     * 内容条件：前面为被替换的内容，后面为替换后内容
     */
    public static final String REPLACE_SPLIT = "_=_";

    /**
     * html编码转换标志：进行转换，0不进行转换
     */
    public static final short ESCAPE_HTML = 1;

    /**
     * 时间戳long类型:0
     */
    public static final String TIME_TYPE_TIMESTAMP = "0";

    /**
     * 标准格式：Thu May 30 14:52:01 +0800 2019
     */
    public static final String TIME_TYPE_CHAR = "2";

    /**
     * 时间中文类型：分钟前，小时前
     */
    public static final String TIME_TYPE_TIME_STR = "1";

}
