package com.bxm.spider.deal.common.constant;

/**
 * 微信专用常量
 *
 * @ClassName WechatConstant
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/30 16:05
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/30 16:05
 **/
public class WechatConstant extends ContentConstant {
    /**
     * 微信去重使用，在微信的列表url返回html中捕捉 微信公众号的名称
     * 微信公众号爬取 必填字段
     */
    public static final String URL_DETAILS_WECHAT_PM_NAME = "url_details_wechat_pm_name";

    /**
     * 微信去重使用，在微信的列表url返回html中捕捉 详情title
     * 微信公众号爬取 必填字段
     */
    public static final String URL_DETAILS_ARTICLE_TITLE = "url_details_article_title";

    /**
     * 微信公众号默认名称
     */
    public static String DEFAULT_WECHAT_PM_NAME = "变现猫";


    /**
     * 微信公众号
     */
    public static String WECHAT_MP = "wechat_mp";
    /**
     * 标题
     */
    public static String TITLE = "title";
    /**
     * 所属频道，分类
     */
    public static String CHANNEL = "channel";
    /**
     * 地区
     */
    public static String REGION = "region";
    /**
     * 新闻发布时间
     */
    public static String DEPLOY_TIME = "deploy_time";
    /**
     * 作者
     */
    public static String AUTHOR = "author";
    /**
     * 新闻来源
     */
    public static String SOURCE = "source";
    /**
     * 内容
     */
    public static String CONTENT = "content";

    /**
     * 全国性新闻region（微信用）
     */
    public static final String NATIONWIDE_REGION = "0";
}
