/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.deal.integration.task;

import com.alibaba.fastjson.JSONObject;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.url.UrlTypeEnum;
import com.bxm.spider.prod.facade.model.dto.TaskUrlDto;
import com.bxm.spider.prod.facade.service.TaskFeignService;
import com.bxm.spider.response.ResponseModel;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(TaskIntegration.class);
    @Autowired
    private TaskFeignService taskFeignService;

    public Boolean pushDetailsList(List<String> urlList, ProcessorParameter processorParameter, Boolean forcedDownload) {
        if (StringUtils.isBlank((CharSequence)processorParameter.getSerialNum())) {
            LOG.warn("\u3010\u53d1\u9001\u8be6\u60c5url\u3011the serialNum is null.");
            return false;
        }
        if (null == urlList || urlList.size() == 0) {
            LOG.warn("\u3010\u53d1\u9001\u8be6\u60c5url\u3011the url list is null,the serial num is {}", (Object)processorParameter.getSerialNum());
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u3010\u53d1\u9001\u8be6\u60c5url\u3011originUrl is {},detail url size is {}\uff0cfirst url is {}", new Object[]{processorParameter.getOriginUrl(), urlList.size(), urlList.get(0)});
        }
        TaskUrlDto taskUrlDto = new TaskUrlDto();
        taskUrlDto.setSerialNum(processorParameter.getSerialNum());
        taskUrlDto.setUrlList(JSONObject.toJSONString(urlList));
        taskUrlDto.setOriginUrl(processorParameter.getOriginUrl());
        taskUrlDto.setForcedDownload(forcedDownload);
        taskUrlDto.setJsonObject(processorParameter.getJsonObject());
        taskUrlDto.setPersistenceEnum(processorParameter.getPersistenceEnum());
        taskUrlDto.setProcessorEnum(processorParameter.getProcessorEnum());
        taskUrlDto.setType((UrlTypeEnum)(processorParameter.getType().equals((Object)UrlTypeEnum.URL_COMMENT) ? UrlTypeEnum.URL_COMMENT : null));
        try {
            ResponseModel result = this.taskFeignService.pushDetailsList(taskUrlDto);
            if (result.isSuccess()) {
                return true;
            }
            LOG.error("\u3010\u53d1\u9001\u8be6\u60c5url\u3011error,msg:{}", (Object)result.getMessage());
            return false;
        }
        catch (Exception e) {
            LOG.error("\u3010\u53d1\u9001\u8be6\u60c5url\u3011error ,the serial number is {}", (Object)processorParameter.getSerialNum(), (Object)e);
            return false;
        }
    }

    public Boolean pushQueueList(List<String> urlList, ProcessorParameter processorParameter, Boolean forcedDownload, Boolean prodFirst) {
        if (StringUtils.isBlank((CharSequence)processorParameter.getSerialNum())) {
            LOG.warn("\u3010\u53d1\u9001\u5217\u8868url\u3011 error,the serialNum is null.");
            return false;
        }
        if (null == urlList || urlList.size() == 0) {
            LOG.warn("\u3010\u53d1\u9001\u5217\u8868url\u3011 error,the url list is null,the serial num is {}", (Object)processorParameter.getSerialNum());
            return false;
        }
        TaskUrlDto taskUrlDto = new TaskUrlDto();
        taskUrlDto.setSerialNum(processorParameter.getSerialNum());
        taskUrlDto.setUrlList(JSONObject.toJSONString(urlList));
        taskUrlDto.setOriginUrl(processorParameter.getOriginUrl());
        taskUrlDto.setForcedDownload(forcedDownload);
        taskUrlDto.setJsonObject(processorParameter.getJsonObject());
        taskUrlDto.setPersistenceEnum(processorParameter.getPersistenceEnum());
        taskUrlDto.setProcessorEnum(processorParameter.getProcessorEnum());
        taskUrlDto.setProdFirst(prodFirst);
        try {
            ResponseModel result = this.taskFeignService.pushQueueList(taskUrlDto);
            if (result.isSuccess()) {
                return true;
            }
            LOG.error("\u3010\u53d1\u9001\u5217\u8868url\u3011error,msg:{}", (Object)result.getMessage());
            return false;
        }
        catch (Exception e) {
            LOG.error("\u3010\u53d1\u9001\u5217\u8868url\u3011 error ,the serial number is {}", (Object)processorParameter.getSerialNum(), (Object)e);
            return false;
        }
    }

    public Boolean pushImageUrl(List<String> urlList, ProcessorParameter processorParameter) {
        if (StringUtils.isBlank((CharSequence)processorParameter.getSerialNum())) {
            LOG.warn("\u3010\u53d1\u9001\u56fe\u7247url\u3011 error,the serialNum is null.");
            return false;
        }
        if (null == urlList || urlList.size() == 0) {
            LOG.warn("\u3010\u53d1\u9001\u56fe\u7247url\u3011 error,the url list is null,the serial num is {}", (Object)processorParameter.getSerialNum());
            return false;
        }
        try {
            TaskUrlDto taskUrlDto = new TaskUrlDto();
            taskUrlDto.setSerialNum(processorParameter.getSerialNum());
            taskUrlDto.setUrlList(JSONObject.toJSONString(urlList));
            taskUrlDto.setOriginUrl(processorParameter.getOriginUrl());
            taskUrlDto.setJsonObject(processorParameter.getJsonObject());
            taskUrlDto.setPersistenceEnum(processorParameter.getPersistenceEnum());
            taskUrlDto.setProcessorEnum(processorParameter.getProcessorEnum());
            taskUrlDto.setForcedDownload(Boolean.valueOf(true));
            ResponseModel result = this.taskFeignService.pushImageList(taskUrlDto);
            LOG.info("\u3010\u53d1\u9001\u56fe\u7247url\u7ed3\u675f\u3011serialNum:{},originUrl:{},url:{}", new Object[]{processorParameter.getSerialNum(), processorParameter.getOriginUrl(), JSONObject.toJSONString(urlList)});
            if (result.isSuccess()) {
                return true;
            }
            LOG.error("\u3010\u53d1\u9001\u56fe\u7247url\u7ed3\u675f\u3011error,msg:{}", (Object)result.getMessage());
            return false;
        }
        catch (Exception e) {
            LOG.error("\u3010\u53d1\u9001\u56fe\u7247url\u3011 error ,the serial number is {}", (Object)processorParameter.getSerialNum(), (Object)e);
            return false;
        }
    }
}

