package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *  视频评论类
 * </p>
 *
 * @author JandMin
 * @since 2018-11-01
 */
public class Comment implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long    id;
    /**
     * 视频id
     */
    private Long    sourceId;
    /**
     * 评论
     */
    private String  content;
    /**
     * 昵称
     */
    private String  nickname;
    /**
     * 头像链接
     */
    private String  imgUrl;
    /**
     * 赞的个数
     */
    private Integer zan;
    /**
     * 评论时间
     */
    private Long    time;
    /**
     * 创建时间
     */
    private Date    createTime;
    /**
     * 修改时间
     */
    private Date    modifyTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getZan() {
        return zan;
    }

    public void setZan(Integer zan) {
        this.zan = zan;
    }

    public Long getTime() {
        return time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public String toString() {
        return "Comment{" +
        "id=" + id +
        ", sourceId=" + sourceId +
        ", content=" + content +
        ", nickname=" + nickname +
        ", imgUrl=" + imgUrl +
        ", zan=" + zan +
        ", time=" + time +
        ", createTime=" + createTime +
        ", modifyTime=" + modifyTime +
        "}";
    }
}
