package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 招聘公司表
 * </p>
 *
 * @author JandMin
 * @since 2018-11-20
 */
@TableName("zhaopin_company")
public class Company implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;
    private String serialNum;
    /**
     * 公司信息url
     */
    private String url;
    private Integer urlCode;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * logo图片url
     */
    private String logoUrl;
    /**
     * 成立时间(yyyy-MM-dd)(yyyy-MM-dd HH:mm:ss)
     */
    private String registerTime;
    /**
     * 所属行业
     */
    private String industry;
    /**
     * 企业性质
     */
    private String companyType;
    /**
     * 注册资金
     */
    private String  registerMoney;
    /**
     * 企业规模
     */
    private String  companyScale;
    /**
     * 所在地址
     */
    private String  address;
    /**
     * 所属区域
     */
    private String  region;
    /**
     * 经度
     */
    private String  longitude;
    /**
     * 纬度
     */
    private String  latitude;
    /**
     * 联系人
     */
    private String  linkman;
    /**
     * 联系电话
     */
    private String  phone;
    /**
     * 联系手机
     */
    private String  mobile;
    /**
     * E-mail
     */
    private String  email;
    /**
     * 公司网址
     */
    private String  website;
    /**
     * 公司简介(html)
     */
    private String  desc;
    /**
     * 删除标记(0-无效 1-有效 2-待更新)
     */
    private Integer status;
    /**
     * 创建时间
     */
    private Date    createTime;
    /**
     * 修改时间
     */
    private Date    modifyTime;

    public Integer getUrlCode() {
        return urlCode;
    }

    public void setUrlCode(Integer urlCode) {
        this.urlCode = urlCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getRegisterTime() {
        return registerTime;
    }

    public void setRegisterTime(String registerTime) {
        this.registerTime = registerTime;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getCompanyType() {
        return companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    public String getRegisterMoney() {
        return registerMoney;
    }

    public void setRegisterMoney(String registerMoney) {
        this.registerMoney = registerMoney;
    }

    public String getCompanyScale() {
        return companyScale;
    }

    public void setCompanyScale(String companyScale) {
        this.companyScale = companyScale;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public String toString() {
        return "Company{" +
        "id=" + id +
        ", url=" + url +
        ", companyName=" + companyName +
        ", logoUrl=" + logoUrl +
        ", industry=" + industry +
        ", companyType=" + companyType +
        ", companyScale=" + companyScale +
        ", address=" + address +
        ", region=" + region +
        ", longitude=" + longitude +
        ", latitude=" + latitude +
        ", linkman=" + linkman +
        ", phone=" + phone +
        ", mobile=" + mobile +
        ", email=" + email +
        ", status=" + status +
        ", createTime=" + createTime +
        ", modifyTime=" + modifyTime +
        "}";
    }
}
