package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * <p>
 * 过滤策略表
 * </p>
 *
 */
@TableName("filter_strategy")
public class FilterStrategy implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("过滤内容")
    private String filterContent;

    @ApiModelProperty("过滤内容类型: 0标题 1内容")
    private Integer filterContentType;

    @ApiModelProperty("过滤类型: 0敏感词 1指定内容删除 2指定内容及之后的内容删除 3包含某个字段直接下线 4某个字段开头直接下线")
    private Integer filterType;

    @ApiModelProperty("状态：0无效 1有效")
    private Integer state;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFilterContent() {
        return filterContent;
    }

    public void setFilterContent(String filterContent) {
        this.filterContent = filterContent;
    }

    public Integer getFilterContentType() {
        return filterContentType;
    }

    public void setFilterContentType(Integer filterContentType) {
        this.filterContentType = filterContentType;
    }

    public Integer getFilterType() {
        return filterType;
    }

    public void setFilterType(Integer filterType) {
        this.filterType = filterType;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
}
