package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 爬取网页内容表(分表)
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
public class News implements Serializable {

    private static final long serialVersionUID = 1L;

    private String  suffix;
    /**
     * 主键id(每张表的尾数步长为10，与表名后缀对应)
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long    id;
    private String serialNum;
    /**
     * 爬取的url(清洗干净)
     */
    private String  url;
    /**
     * url的hashCode
     */
    private Integer  urlCode;
    /**
     * 图片 url
     */
    private String  imgUrl;
    /**
     * 标题
     */
    private String  title;
    /**
     * 导航(用|区分)
     */
    private String  navigation;
    /**
     * 关键字
     */
    private String  keyword;
    /**
     * 频道
     */
    private String  channel;
    /**
     * 地区
     */
    private String  region;
    /**
     * 新闻发布时间
     */
    private String  deployTime;
    /**
     * 作者
     */
    private String  author;
    /**
     * 来源
     */
    private String  source;
    /**
     * 浏览器更新时间
     */
    private String  lastModified;
    /**
     * 删除标记(0-无效 1-有效 2-待更新)
     */
    private Integer status;
    /**
     * 标签: 1 hot
     */
    private Short label;
    /**
     * 创建时间
     */
    private Date    createTime;
    /**
     * 修改时间
     */
    private Date    modifyTime;

    public Short getLabel() {
        return label;
    }

    public void setLabel(Short label) {
        this.label = label;
    }

    public Integer getUrlCode() {
        return urlCode;
    }

    public void setUrlCode(Integer urlCode) {
        this.urlCode = urlCode;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNavigation() {
        return navigation;
    }

    public void setNavigation(String navigation) {
        this.navigation = navigation;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getDeployTime() {
        return deployTime;
    }

    public void setDeployTime(String deployTime) {
        this.deployTime = deployTime;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getLastModified() {
        return lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public String toString() {
        return "News0{" +
                "id=" + id +
                ", url=" + url +
                ", title=" + title +
                ", navigation=" + navigation +
                ", channel=" + channel +
                ", deployTime=" + deployTime +
                ", author=" + author +
                ", source=" + source +
                ", lastModified=" + lastModified +
                ", status=" + status +
                ", createTime=" + createTime +
                ", modifyTime=" + modifyTime +
                "}";
    }
}
