package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 新闻评论表
 * </p>
 *
 * @author JandMin
 * @since 2019-03-04
 */
public class NewsComment implements Serializable {

    private static final long serialVersionUID = 1L;
    private String suffix;
    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;
    /**
     * 新闻关联id,尾号为分表尾号
     */
    private Long sourceId;
    /**
     * 评论内容
     */
    private String content;
    /**
     * 用户昵称
     */
    private String nickname;
    /**
     * 用户头像
     */
    private String authImg;
    /**
     * 被评论次数
     */
    private Integer commentTimes;
    /**
     * 被点赞次数
     */
    private Integer praiseTimes;
    /**
     * 评论时间
     */
    private Date deployTime;
    /**
     * 上一级评论id
     */
    private Long parentId;
    /**
     * 创建时间
     */
    private Date createTime;

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getAuthImg() {
        return authImg;
    }

    public void setAuthImg(String authImg) {
        this.authImg = authImg;
    }

    public Integer getCommentTimes() {
        return commentTimes;
    }

    public void setCommentTimes(Integer commentTimes) {
        this.commentTimes = commentTimes;
    }

    public Integer getPraiseTimes() {
        return praiseTimes;
    }

    public void setPraiseTimes(Integer praiseTimes) {
        this.praiseTimes = praiseTimes;
    }

    public Date getDeployTime() {
        return deployTime;
    }

    public void setDeployTime(Date deployTime) {
        this.deployTime = deployTime;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "NewsComment{" +
        "id=" + id +
        ", sourceId=" + sourceId +
        ", content=" + content +
        ", nickname=" + nickname +
        ", authImg=" + authImg +
        ", commentTimes=" + commentTimes +
        ", praiseTimes=" + praiseTimes +
        ", deployTime=" + deployTime +
        ", parentId=" + parentId +
        ", createTime=" + createTime +
        "}";
    }
}
