package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 微信爬取网页内容表
 * </p>
 *
 * @author kk.xie
 * @since 2018-10-30
 */
public class NewsWechat implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;
    private String serialNum;
    /**
     * 微信公众号
     */
    private String wechatMp;
    /**
     * 标题
     */
    private String title;
    /**
     * 微信新闻图片
     */
    private String imgUrl;
    /**
     * 所属频道，分类
     */
    private String channel;
    /**
     * 地区
     */
    private String region;
    /**
     * 新闻发布时间
     */
    private String deployTime;
    /**
     * 作者
     */
    private String author;
    /**
     * 新闻来源
     */
    private String source;
    /**
     * 删除标记(0-无效 1-有效 2-待更新)
     */
    private Integer status;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date modifyTime;


    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getWechatMp() {
        return wechatMp;
    }

    public void setWechatMp(String wechatMp) {
        this.wechatMp = wechatMp;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDeployTime() {
        return deployTime;
    }

    public void setDeployTime(String deployTime) {
        this.deployTime = deployTime;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public String toString() {
        return "NewsWechat{" +
                "id=" + id +
                ", wechatMp='" + wechatMp + '\'' +
                ", title='" + title + '\'' +
                ", imgUrl='" + imgUrl + '\'' +
                ", channel='" + channel + '\'' +
                ", region='" + region + '\'' +
                ", deployTime='" + deployTime + '\'' +
                ", author='" + author + '\'' +
                ", source='" + source + '\'' +
                ", status=" + status +
                ", createTime=" + createTime +
                ", modifyTime=" + modifyTime +
                '}';
    }
}
