package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;

/**
 * <p>
 * 规则条件关联表
 * </p>
 *
 * @author JandMin
 * @since 2019-04-12
 */
public class RulerCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 条件编码
     */
    private String  handler;
    /**
     * 规则id
     */
    private Long    rulerId;
    /**
     * 条件内容(规则参考条件条件表的描述)
     */
    private String  value;
    /**
     * 状态：0不可用 1可用
     */
    private Integer status;


    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getHandler() {
        return handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Long getRulerId() {
        return rulerId;
    }

    public void setRulerId(Long rulerId) {
        this.rulerId = rulerId;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "RulerCondition{" +
        "id=" + id +
        ", handler=" + handler +
        ", rulerId=" + rulerId +
        ", value=" + value +
        ", status=" + status +
        "}";
    }
}
