package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 过滤规则表
 * </p>
 *
 * @author JandMin
 * @since 2018-10-16
 */
public class UrlRuler implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 站点
     */
    private String site;
    /**
     * 规则详情名称
     */
    private String name;
    /**
     * 需要匹配的内容
     */
    private String keyword;
    /**
     * 匹配规则
     */
    private String ruler;
    /**
     * 下一页的参数名称:用于获取下一页的参数加 1 (page)
     */
    private String nextPagePara;
    /**
     * 站点前缀(解析一些特殊url时配置)
     */
    private String prefix;
    /**
     * 替换规则
     */
    private String replacement;
    /**
     * 默认值
     */
    private String defaultValue;
    /**
     * 是否非空(0-否 1-是)
     */
    private Integer emptyFlag;
    /**
     * 后缀
     */
    private String  suffix;
    /**
     * 时间转换格式
     */
    private String timePatter;
    /**
     * 是否html编码转换：0不转换，1转换
     */
    private Short escapeHtml;
    /**
     * 报文分析工具，使用正则式:REGEX,JSOUP:JSOUP
     */
    private String analyticalTools;
    /**
     * 父站点地址
     */
    private String parentSite;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人
     */
    private String createUser;
    /**
     * 修改时间
     */
    private Date modifyTime;
    /**
     * 修改人
     */
    private String modifyUser;
    /**
     * 规则类型：1 列表规则(url_);2 详情规则;3 评论规则
     */
    private Short type;

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Short getEscapeHtml() {
        return escapeHtml;
    }

    public void setEscapeHtml(Short escapeHtml) {
        this.escapeHtml = escapeHtml;
    }

    public String getTimePatter() {
        return timePatter;
    }

    public void setTimePatter(String timePatter) {
        this.timePatter = timePatter;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getNextPagePara() {
        return nextPagePara;
    }

    public void setNextPagePara(String nextPagePara) {
        this.nextPagePara = nextPagePara;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getReplacement() {
        return replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getRuler() {
        return ruler;
    }

    public void setRuler(String ruler) {
        this.ruler = ruler;
    }

    public Integer getEmptyFlag() {
        return emptyFlag;
    }

    public void setEmptyFlag(Integer emptyFlag) {
        this.emptyFlag = emptyFlag;
    }

    public String getParentSite() {
        return parentSite;
    }

    public void setParentSite(String parentSite) {
        this.parentSite = parentSite;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String getModifyUser() {
        return modifyUser;
    }

    public void setModifyUser(String modifyUser) {
        this.modifyUser = modifyUser;
    }

    public String getAnalyticalTools() {
        return analyticalTools;
    }

    public void setAnalyticalTools(String analyticalTools) {
        this.analyticalTools = analyticalTools;
    }

    @Override
    public String toString() {
        return "UrlRuler{" +
                "id=" + id +
                ", site='" + site + '\'' +
                ", name='" + name + '\'' +
                ", keyword='" + keyword + '\'' +
                ", ruler='" + ruler + '\'' +
                ", nextPagePara='" + nextPagePara + '\'' +
                ", prefix='" + prefix + '\'' +
                ", replacement='" + replacement + '\'' +
                ", defaultValue='" + defaultValue + '\'' +
                ", emptyFlag=" + emptyFlag +
                ", suffix='" + suffix + '\'' +
                ", timePatter='" + timePatter + '\'' +
                ", escapeHtml=" + escapeHtml +
                ", analyticalTools=" + analyticalTools +
                ", parentSite='" + parentSite + '\'' +
                ", remark='" + remark + '\'' +
                ", createTime=" + createTime +
                ", createUser='" + createUser + '\'' +
                ", modifyTime=" + modifyTime +
                ", modifyUser='" + modifyUser + '\'' +
                '}';
    }
}
