package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 爬取小视频表
 * </p>
 *
 * @author JandMin
 * @since 2018-10-31
 */
public class Video implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;
    private String serialNum;
    /**
     * 来源url
     */
    private String url;
    /**
     * url的hashCode
     */
    private Integer urlCode;
    /**
     * 用户昵称
     */
    private String nickname;
    /**
     * 作者头像图片链接
     */
    private String authorImageUrl;
    /**
     * 视频id
     */
    private String videoId;
    /**
     * 标题
     */
    private String title;
    /**
     * 视频描述
     */
    private String desc;
    /**
     * 视频封面图
     */
    private String videoImageUrl;
    /**
     * 视频url
     */
    private String videoUrl;
    /**
     * 删除标记(0-无效 1-有效 2-待更新)
     */
    private Integer status;
    /**
     * 赞的数量
     */
    private Integer zan;
    /**
     * 来源
     */
    private String source;
    /**
     * 频道(抖音)
     */
    private String channel;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date modifyTime;
    /**
     * 高宽比例
     */
    private Double widthRatio;

    public Double getWidthRatio() {
        return widthRatio;
    }

    public void setWidthRatio(Double widthRatio) {
        this.widthRatio = widthRatio;
    }

    public Integer getUrlCode() {
        return urlCode;
    }

    public void setUrlCode(Integer urlCode) {
        this.urlCode = urlCode;
    }

    public Integer getZan() {
        return zan;
    }

    public void setZan(Integer zan) {
        this.zan = zan;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getAuthorImageUrl() {
        return authorImageUrl;
    }

    public void setAuthorImageUrl(String authorImageUrl) {
        this.authorImageUrl = authorImageUrl;
    }

    public String getVideoId() {
        return videoId;
    }

    public void setVideoId(String videoId) {
        this.videoId = videoId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getVideoImageUrl() {
        return videoImageUrl;
    }

    public void setVideoImageUrl(String videoImageUrl) {
        this.videoImageUrl = videoImageUrl;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public String toString() {
        return "Video{" +
        "id=" + id +
        ", url=" + url +
        ", nickname=" + nickname +
        ", authorImageUrl=" + authorImageUrl +
        ", videoId=" + videoId +
        ", title=" + title +
        ", desc=" + desc +
        ", videoImageUrl=" + videoImageUrl +
        ", videoUrl=" + videoUrl +
        ", status=" + status +
        ", source=" + source +
        ", createTime=" + createTime +
        ", modifyTime=" + modifyTime +
        "}";
    }
}
