package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 爬取微信新闻内容表(分表)
 * </p>
 *
 * @author stephen
 * @since 2019-01-03
 */
public class WechatNews implements Serializable {
    private static final long serialVersionUID = 1L;

    private String  suffix;
    /**
     * 主键id(每张表的尾数步长为10，与表名后缀对应)
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long    id;
    private String serialNum;
    /**
     * title的hashCode
     */
    private Integer  titleCode;
    /**
     * 公众号名称
     */
    private String  name;
    /**
     * 公众号账号
     */
    private String  account;
    /**
     * 图片 url
     */
    private String  imgUrl;
    /**
     * 标题
     */
    private String  title;
    /**
     * 关键字
     */
    private String  keyword;
    /**
     * 频道
     */
    private String  channel;
    /**
     * 地区
     */
    private String  region;
    /**
     * 新闻发布时间
     */
    private String  deployTime;
    /**
     * 作者
     */
    private String  author;
    /**
     * 来源
     */
    private String  source;
    /**
     * 删除标记(0-无效 1-有效 2-待更新)
     */
    private Integer status;
    /**
     * 创建时间
     */
    private Date    createTime;
    /**
     * 修改时间
     */
    private Date    modifyTime;

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public Integer getTitleCode() {
        return titleCode;
    }

    public void setTitleCode(Integer titleCode) {
        this.titleCode = titleCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDeployTime() {
        return deployTime;
    }

    public void setDeployTime(String deployTime) {
        this.deployTime = deployTime;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}
