package com.bxm.spider.deal.model.dao;

import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 招聘职位表
 * </p>
 *
 * @author JandMin
 * @since 2018-11-20
 */
@TableName("zhaopin_work")
public class Work implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;
    private String serialNum;
    /**
     * 公司简称或全称
     */
    private String companySimpleName;
    /**
     * 公司url
     */
    private String companyUrl;
    /**
     * 职位url
     */
    private String url;
    /**
     * url的hashCode
     */
    private Integer urlCode;
    /**
     * 岗位名称
     */
    private String name;
    /**
     * 职位类型(全职/兼职)
     */
    private String workType;
    /**
     * 性别要求
     */
    private String sex;
    /**
     * 年龄要求
     */
    private String age;
    /**
     * 招聘人数
     */
    private String peopleNum;
    /**
     * 薪资待遇
     */
    private String salary;
    /**
     * 工作区域
     */
    private String region;
    /**
     * 学历要求
     */
    private String education;
    /**
     * 工作经验
     */
    private String  experience;
    /**
     * 发布时间(yyyy-MM-dd)(yyyy-MM-dd HH:mm:ss)
     */
    private String  deployTime;
    /**
     * 截至时间(yyyy-MM-dd)(yyyy-MM-dd HH:mm:ss)
     */
    private String  endTime;
    /**
     * 具体要求
     */
    private String  desc;
    /**
     * 工作地址
     */
    private String  address;
    /**
     * 联系人
     */
    private String  linkman;
    /**
     * 联系电话
     */
    private String  phone;
    /**
     * 联系手机
     */
    private String  mobile;
    /**
     * E-mail
     */
    private String  email;
    /**
     * 删除标记(0-无效 1-有效 2-待更新)
     */
    private Integer status;
    /**
     * 创建时间
     */
    private Date    createTime;
    /**
     * 修改时间
     */
    private Date    modifyTime;

    public Integer getUrlCode() {
        return urlCode;
    }

    public void setUrlCode(Integer urlCode) {
        this.urlCode = urlCode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getCompanySimpleName() {
        return companySimpleName;
    }

    public void setCompanySimpleName(String companySimpleName) {
        this.companySimpleName = companySimpleName;
    }

    public String getCompanyUrl() {
        return companyUrl;
    }

    public void setCompanyUrl(String companyUrl) {
        this.companyUrl = companyUrl;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWorkType() {
        return workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }

    public String getSex() {
        return sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getAge() {
        return age;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public String getPeopleNum() {
        return peopleNum;
    }

    public void setPeopleNum(String peopleNum) {
        this.peopleNum = peopleNum;
    }

    public String getSalary() {
        return salary;
    }

    public void setSalary(String salary) {
        this.salary = salary;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEducation() {
        return education;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public String getExperience() {
        return experience;
    }

    public void setExperience(String experience) {
        this.experience = experience;
    }

    public String getDeployTime() {
        return deployTime;
    }

    public void setDeployTime(String deployTime) {
        this.deployTime = deployTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    public String toString() {
        return "Work{" +
        "id=" + id +
        ", companySimpleName=" + companySimpleName +
        ", companyUrl=" + companyUrl +
        ", url=" + url +
        ", name=" + name +
        ", workType=" + workType +
        ", sex=" + sex +
        ", age=" + age +
        ", peopleNum=" + peopleNum +
        ", salary=" + salary +
        ", region=" + region +
        ", education=" + education +
        ", experience=" + experience +
        ", deployTime=" + deployTime +
        ", endTime=" + endTime +
        ", linkman=" + linkman +
        ", phone=" + phone +
        ", mobile=" + mobile +
        ", email=" + email +
        ", status=" + status +
        ", createTime=" + createTime +
        ", modifyTime=" + modifyTime +
        "}";
    }
}
