package com.bxm.spider.deal.model.dto;

import com.bxm.spider.constant.url.UrlTypeEnum;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @ClassName 规则匹配测试用，后期删除
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2018/10/30 16:20
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2018/10/30 16:20
 **/
public class RulerTestDto implements Serializable {
    /**
     * url
     */
    @ApiModelProperty("目标url")
    private String url;
    /**
     * 流水号
     */
    @ApiModelProperty("流水号")
    private String serialNum;

    /**
     * 种子url
     */
    @ApiModelProperty("种子url")
    private String originUrl;
    /**
     * url类型: 1-列表url：URL_LIST 2-详情url：URL_DETAIL 3-图片url：URL_IMAGE
     * 用枚举类实现
     */
    @ApiModelProperty("url类型：1-列表url：URL_LIST 2-详情url：URL_DETAIL")
    private UrlTypeEnum type;

    /**
     * 封装 json 的对象
     */
    @ApiModelProperty("封装 json 的对象")
    private String jsonObject;


    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getOriginUrl() {
        return originUrl;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    public UrlTypeEnum getType() {
        return type;
    }

    public void setType(UrlTypeEnum type) {
        this.type = type;
    }

    public String getJsonObject() {
        return jsonObject;
    }

    public void setJsonObject(String jsonObject) {
        this.jsonObject = jsonObject;
    }
}
