package com.bxm.spider.deal.model.dto;

import java.util.List;

/**
 * <p> 视频解析类 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/10/30
 */
public class VideoDto {
    /**
     * 任务流水号
     */
    private String serialNum;
    private Long id;
    /**
     * 标题
     */
    private String desc;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 视频id
     */
    private String video_url;
    /**
     * 昵称
     */
    private String nickname;
    /**
     * 视频图片
     */
    private String video_img;
    /**
     * 统计数据
     */
    private VideoCount statistics;
    /**
     * 评论数据
     */
    private List<VideoCommentDto> comments;

    private String video_id;
    private String source_url;
    private Integer zan;
    /**
     * 来源
     */
    private String source;
    /**
     * 频道(抖音)
     */
    private String channel;
    private String imgUlrPrefix;

    // 视频长宽比例
    private String widthRatio;

    private String commentUrl;

    public String getWidthRatio() {
        return widthRatio;
    }

    public void setWidthRatio(String widthRatio) {
        this.widthRatio = widthRatio;
    }

    public String getSerialNum() {
        return serialNum;
    }

    public void setSerialNum(String serialNum) {
        this.serialNum = serialNum;
    }

    public String getImgUlrPrefix() {
        return imgUlrPrefix;
    }

    public void setImgUlrPrefix(String imgUlrPrefix) {
        this.imgUlrPrefix = imgUlrPrefix;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getZan() {
        return zan;
    }

    public void setZan(Integer zan) {
        this.zan = zan;
    }

    public VideoCount getStatistics() {
        return statistics;
    }

    public void setStatistics(VideoCount statistics) {
        this.statistics = statistics;
    }

    public List<VideoCommentDto> getComments() {
        return comments;
    }

    public void setComments(List<VideoCommentDto> comments) {
        this.comments = comments;
    }

    public String getSource_url() {
        return source_url;
    }

    public void setSource_url(String source_url) {
        this.source_url = source_url;
    }

    public String getVideo_id() {
        return video_id;
    }

    public void setVideo_id(String video_id) {
        this.video_id = video_id;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getVideo_url() {
        return video_url;
    }

    public void setVideo_url(String video_url) {
        this.video_url = video_url;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getVideo_img() {
        return video_img;
    }

    public void setVideo_img(String video_img) {
        this.video_img = video_img;
    }

    public String getCommentUrl() {
        return commentUrl;
    }

    public void setCommentUrl(String commentUrl) {
        this.commentUrl = commentUrl;
    }

    @Override
    public String toString() {
        return "VideoDto{" +
                "serialNum='" + serialNum + '\'' +
                ", id=" + id +
                ", desc='" + desc + '\'' +
                ", avatar='" + avatar + '\'' +
                ", video_url='" + video_url + '\'' +
                ", nickname='" + nickname + '\'' +
                ", video_img='" + video_img + '\'' +
                ", statistics=" + statistics +
                ", comments=" + comments +
                ", video_id='" + video_id + '\'' +
                ", source_url='" + source_url + '\'' +
                ", zan=" + zan +
                ", source='" + source + '\'' +
                ", channel='" + channel + '\'' +
                ", imgUlrPrefix='" + imgUlrPrefix + '\'' +
                ", widthRatio='" + widthRatio + '\'' +
                ", commentUrl='" + commentUrl + '\'' +
                '}';
    }
}
