package com.bxm.spider.deal.model.wechat;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;

/**
 * 微信json返回对象包装
 *
 * @ClassName WechatAppMsgExtInfo
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/30 16:49
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/30 16:49
 **/
public class WechatAppMsgExtInfo {

    /**
     * 列表url地址
     */
    @JSONField(name = "content_url")
    private String contentUrl;

    /**
     * 标题
     */
    private String title;

    @JSONField(name = "multi_app_msg_item_list")
    private List<WechatMultiAppMsg> wechatMultiAppMsgList;

    public List<WechatMultiAppMsg> getWechatMultiAppMsgList() {
        return wechatMultiAppMsgList;
    }

    public void setWechatMultiAppMsgList(List<WechatMultiAppMsg> wechatMultiAppMsgList) {
        this.wechatMultiAppMsgList = wechatMultiAppMsgList;
    }

    public String getContentUrl() {
        return contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String toString() {
        return "WechatAppMsgExtInfo{" +
                "contentUrl='" + contentUrl + '\'' +
                ", title='" + title + '\'' +
                ", wechatMultiAppMsgList=" + wechatMultiAppMsgList +
                '}';
    }
}
