package com.bxm.spider.deal.model.wechat;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.List;

/**
 * 微信json 返回值封装对象
 *
 * @ClassName WechatNewsBo
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/10/30 17:13
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/10/30 17:13
 **/
public class WechatNewsBo implements Serializable{
    private static final long serialVersionUID = -1867532425221056887L;
    @JSONField(name = "app_msg_ext_info")
    private WechatAppMsgExtInfo wechatAppMsgExtInfo;

    public WechatAppMsgExtInfo getWechatAppMsgExtInfo() {
        return wechatAppMsgExtInfo;
    }

    public void setWechatAppMsgExtInfo(WechatAppMsgExtInfo wechatAppMsgExtInfo) {
        this.wechatAppMsgExtInfo = wechatAppMsgExtInfo;
    }

    @Override
    public String toString() {
        return "WechatNewsBo{" +
                "wechatAppMsgExtInfo=" + wechatAppMsgExtInfo +
                '}';
    }

    public static void main(String[] args) {
        String json = "[{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"贾飞黄\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsLm8Y09PlCedLZfPHFjAKVJhVNUeSeOxweMJxluEEEnmMeUqUbQlwvq4QdVq3YLrNKwmFDlPrcpVqjnhJFK1Rjk=\",\"copyright_stat\":101,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWk8EKGTc5IxBIBEPaDCr5gxJ1BtL1gOdQcUUIhrms6aNic7VKw6H0NicJQ/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"给“老实”正名！\",\"duration\":0,\"fileid\":518738347,\"is_multi\":1,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsLm8Y09PlCedLZfPHFjAKVLqDkIoyUZThVIw9Rx4eZrjE-sxroZE4Tx6W-JSgit5GUAK9WaBYwAT3-uo-zobCfw=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWkBaYl4ZZ95MWRh9q2wjQaZWjiaEAavlU6zyGnMic9WQQWDEqo8eHPdxPw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"注意！\",\"duration\":0,\"fileid\":518738342,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MzA4NDI3NjcyNA==&amp;mid=2649417038&amp;idx=3&amp;sn=9b1538b1cb05112b37301b8be51d6736&amp;chksm=87f7e1d5b08068c391147ec492df5a93f686c3301a2095ba506fcfc97996f7a0df9cfa11fd87&amp;mpshare=1&amp;scene=1&amp;srcid=1030UMRtc9zGGhZkYnoDRSP7&amp;pass_ticket=HKF%2FsVLCAIbYZvaBM0Zq%2BKchZhxNckH6dNiFlW0F2HWPSdgnKpiSFxoJB6ABNHpN#rd\",\"title\":\"【关注】高铁上这位“父亲宠女儿”的“特殊”方式，公安回应了！\"},{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsLm8Y09PlCedLZfPHFjAKVJltozEkjNPHiTAtr95AyHXr5q1pZ3Gdmu9cq5WHSahfKAuW53groAYXFDShXzVOkU=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWksy4WoWwFibPA1LwiaNFKHBuu9eWiaPecxgibPSkqLkC5tbADpD6DzJ9hUQ/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"必看\",\"duration\":0,\"fileid\":518738334,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/jPhuMnGOJZVbiASPa78lAQ\",\"title\":\"【健康】一个动作了断：脖子痛、腰痛、膝盖痛......赶紧收好，错过后悔！\"},{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsLm8Y09PlCedLZfPHFjAKVI-jR7KOcNzyDqvyATBELDVWQx0vPZc4Rw4mFs3WbA9kHea59WYKtH32pmBbKCXFDo=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWkricon6oIQIkmrv7Hf5suZAqzOSxhwUBLLNmyY0icK3mSnI7U31IjHTVg/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"哈哈哈！\",\"duration\":0,\"fileid\":518738337,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/fl6NJ57pOfhfjVxiFIFTog\",\"title\":\"【荐读】嗯，就是这味儿…看我东北人是如何改造全国小吃的\"}],\"play_url\":\"\",\"source_url\":\"https://app.peopleapp.com/Api/600/DetailApi/shareArticle?type=0&amp;article_id=2769077&amp;from=groupmessage&amp;isappinstalled=0\",\"subtype\":9,\"title\":\"人民日报刊文：“老实”绝不可耻，“老实人”不必自惭形秽\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540882512,\"fakeid\":\"2392014380\",\"id\":1000006750,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsEM9uXF4mkAYKn8V2vt17OoRxJLKzbVlao7PynBPFmeqU0mFrX*Z8**s8PxYodvvgLM9rz66P5HaD2AlRg98Peg=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWk3aibBHAT0Mz304YGkGKBARIlt12fbDibWcbOoFG5FvZTK9INy1IGtDCw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"\",\"duration\":0,\"fileid\":518738327,\"is_multi\":0,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[],\"play_url\":\"\",\"source_url\":\"https://app.peopleapp.com/Api/600/DetailApi/shareArticle?type=0&amp;article_id=2771647&amp;from=singlemessage&amp;isappinstalled=0\",\"subtype\":9,\"title\":\"回应对“一带一路”误读，人民日报社社长在这个论坛上亮明四个观点\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540876405,\"fakeid\":\"2392014380\",\"id\":1000006749,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsJsZ-q622GDtLd8AzEL9Jyj5RFEeva-s02KZFbhgbtocsHP6EIgj-gIDcM6Eyfzhf8CdmKAlBS7DLhyr*8-vbkE=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWkC9Zp3fPibCofvnKLicN8DL3ictZb8tiav4vrZLWibQnMZCVTxxDTGxTAq9A/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"点赞！\",\"duration\":0,\"fileid\":518738311,\"is_multi\":1,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsJsZ-q622GDtLd8AzEL9Jyj*7VXzjkKV4NQ3LPM6qc8ssbxa40el90ejTVzHgqKV8TJe5vlEWTCoxqSb3awlAO8=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWkDM81XtkyRqaial1MncVqOC5c5X0fh6NmvDGfyYLXsfZOsYKQZJmiafsw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"注意！\",\"duration\":0,\"fileid\":518738314,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MjM5NzI3NDg4MA==&amp;mid=2658523512&amp;idx=4&amp;sn=446b9437cc7b755dfe9dc864b9f5f2e7&amp;chksm=bd5d0d178a2a8401e3361d399d0bb97e5dda46a9aa6e0c0cce4b2d8d143b5ed6af9070574551&amp;mpshare=1&amp;scene=1&amp;srcid=1029qSQQMMYiV1xyvSbTYUxQ&amp;pass_ticket=rrgLrHBt9%2FdQCFDQOvJuFwzP5aLfO15uyVfAUQYfI3jNvfBPChzeZPqAmCWH8ikN#rd\",\"title\":\"【提醒】几毛成本，卖几百！有人靠它疯狂圈钱近7000万！真相惊人\"},{\"audio_fileid\":0,\"author\":\"健康时报微信\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsJsZ-q622GDtLd8AzEL9JygZV4ep-zGrm6qacd57MNqgSDFIabiNHui0BJ9TgjzfDQ4YPWyblOLRxMCOu4ss2xA=\",\"copyright_stat\":101,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWkrdhZjDrugdLFd38azialIdR2OuibLEpTlqal8oWf0ic9YWnh1OUpdA0icw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"必看！\",\"duration\":0,\"fileid\":518738322,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MjM5MDg3MDYwMQ==&amp;mid=2650048583&amp;idx=1&amp;sn=e816f4093bbc22422ce681d63c8b2bb1&amp;chksm=bebe156189c99c7758c6e462f928fd0317d913dec9013b3417e779bcb05f0ad74ebc5fd9427b&amp;mpshare=1&amp;scene=1&amp;srcid=1025UD17a7rkaNFcdRqlYJpL&amp;pass_ticket=rrgLrHBt9%2FdQCFDQOvJuFwzP5aLfO15uyVfAUQYfI3jNvfBPChzeZPqAmCWH8ikN#rd\",\"title\":\"【健康】10多家医院院长和科主任总结的“看病技巧”，看好病还少受罪！收藏\"},{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsJsZ-q622GDtLd8AzEL9JygNNA5KPCAxU-IbQuCSncDu4637dwWE6l6RwZ7nkrIwV5AH0CvuTr-7YcNdagGL0Y8=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08BJibmfsf8I8r8y0N73R5AWkylWr75iaicciacdQhRAcYicJ3vye568jW6lrgjAMedTfVNv2CGXDPNHcFw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"哈哈哈！\",\"duration\":0,\"fileid\":518738317,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/9_QP5ZyqBx6fMTebFfJAUA\",\"title\":\"【荐读】笑喷！各行业奇葩事曝光，看完笑出声哈哈哈哈哈哈！\"}],\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MTI0MDU3NDYwMQ==&amp;mid=2656708901&amp;idx=1&amp;sn=97a3373ae4ae1be2835d256b25dd3080&amp;chksm=7a60d4c34d175dd5a5a7c2bec284ec0fbef33356911dd480eaf7ff16d07e74133f5cba7c3c8c&amp;mpshare=1&amp;scene=1&amp;srcid=1030nQNeclwXx1KvK29jDoyR&amp;pass_ticket=rrgLrHBt9%2FdQCFDQOvJuFwzP5aLfO15uyVfAUQYfI3jNvfBPChzeZPqAmCWH8ikN#rd\",\"subtype\":9,\"title\":\"他“身价”千万，每天穿70斤衣服与死神博弈\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540869476,\"fakeid\":\"2392014380\",\"id\":1000006748,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"王成龙的战友们\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsMLj3xf5yHjzfXnnfrh2R7FoR5RYi4cPzCgmSV9zYr5BuTpauKyj6lJ0bevg3oXzaXr0wW2uQB9ciojDI8zvQhU=\",\"copyright_stat\":101,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPtuIShaxLXvwNfrpSlPiaAb1Y6ZibH6MGicD7brjMa7Y4rXHpYhBMImhPg/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"一路走好\",\"duration\":0,\"fileid\":518738305,\"is_multi\":1,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsMLj3xf5yHjzfXnnfrh2R7Fvjm8YnKqsGH-COkxSCwKz-7Pb4HzCu9M-EKoW4dy4xNaZ3T2lDGhHtXmuXo7RqHA=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPk5icY7WZIQ5cC9NvGB1zd3UQxDkJfayic4ILIfv8SIS3ViasqEm1takSQ/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"注意\",\"duration\":0,\"fileid\":518738300,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/cQGBhv_E5wVO5aV5dOF62Q\",\"title\":\"【提醒】太惨了……不是特效也不是假人，这是真的\"},{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsMLj3xf5yHjzfXnnfrh2R7Fu9*4P0CLEfse1ab4sbrIuMJtuKjho9mAteWgXIDyy5KCI*vs6YEAO*XC9YqchmHM=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPgk04symWsSmkHM2UlaNdxUWibXeI0YJjFwGOQX4UbYPWnOvKTRP1MoA/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"必看\",\"duration\":0,\"fileid\":518738298,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/BS_kUdnJwo5oikZnAqpBkA\",\"title\":\"【健康】爬山偶遇外交部长王毅！部长说：年轻人要多运动啊！\"},{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsMLj3xf5yHjzfXnnfrh2R7ELKjnfA1VS*WY7gLaOuD8uNIDkZCmEHrPD7bJa3vK92IrHx-0i1NxdzpXgj7XZks0=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPFCK8EezRROcj2tts4K8Hv80kBzmz294mRqXZfibzlwh5po7oLKSLp7w/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"你觉得呢？\",\"duration\":0,\"fileid\":518738296,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/EqKxGJIR9Hu0QU3crB2Mvg\",\"title\":\"【荐读】大学生跪求“双11”不断网，学校毫无意外地...\"}],\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/5o2lD_jmhTLMBi7_zw8nlQ\",\"subtype\":9,\"title\":\"我的战友，毕业1个月，牺牲了。\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540856254,\"fakeid\":\"2392014380\",\"id\":1000006747,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsGMRNRBrfvryRECiRb0RBIpR49g0JbtFgZFFAKMt536WSXC1WvgdF28aLh6MmyWc820lMtDTw*PIz-sgx7gSyU0=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPWfprmraEwdN7VQyXLmA5YYByXzkBM9EkibRxYibAic6f7q4DibYoByLh9A/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"\",\"duration\":0,\"fileid\":518738282,\"is_multi\":0,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[],\"play_url\":\"\",\"source_url\":\"http://h5.peopleapp.com/appdownload/?from=listen\",\"subtype\":9,\"title\":\"微视频 | 上海一分钟\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540852559,\"fakeid\":\"2392014380\",\"id\":1000006746,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsC-fHV0uirmXahpZsTJDqbsGVab-*s*qrXAKv6pCs0kzMweyevzGZnjiOelhREFMYheSQSBTISpfFlKkT682XwE=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPgRmj4pm2llQsZvIIylfG0y10Dyv0BOKC2jpXoOA2MQwGaOccF1UGiag/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"昨夜，你错过了哪些大事？今天，有什么新闻将发生？\",\"duration\":0,\"fileid\":518738232,\"is_multi\":0,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[],\"play_url\":\"\",\"source_url\":\"http://h5.peopleapp.com/appdownload/?from=listen\",\"subtype\":9,\"title\":\"来了！新闻早班车\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540849896,\"fakeid\":\"2392014380\",\"id\":1000006745,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"一梨\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsGCbZngueDNterjMkeIs5AQZfa7RCL02J0K9daT0VM6JnOO0jMm8zHTe2dGXYRaQRtvE4p-k1FVneuPBJa*PtQY=\",\"copyright_stat\":101,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPJy9PlRdKClntNxcBqTMnnpTb7Ozs03xUVU3ibMF17tudkI34XA3VyEw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"\",\"duration\":0,\"fileid\":518738166,\"is_multi\":0,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[],\"play_url\":\"\",\"source_url\":\"http://h5.peopleapp.com/appdownload/?from=listen\",\"subtype\":9,\"title\":\"【夜读】不认真，你连输的资格都没有\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540821769,\"fakeid\":\"2392014380\",\"id\":1000006744,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsAYd*S0Lq76jq5VeGaMSgrEKfrgMaSd0*aZ8DMc8nU-pU9m5RzhpSc0tivWvhnTsqXIoutHZaUv2MZVom7nDwaM=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPnJuFk6T53oH49ia9xEF2PHJtiahFiabeNJl0eU0ibwib3lVOQecZHEEq5JQ/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"这个世界，有人永远爱着你！\",\"duration\":0,\"fileid\":518738199,\"is_multi\":1,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsAYd*S0Lq76jq5VeGaMSgrGDQMZf2O382VCHGiyTzr9I9kzSb9WBo4NwcNir4ToZxsOdnTzJ9scFSl-i-yGvrmY=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPicqfVIPQvsibbVRIRzCicQL6lg2JRf3khWTcBD5y9yJluARv5McSxOJicQ/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"揪心！\",\"duration\":0,\"fileid\":518738194,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/ZbFIKWi0grxZiHyndecJ9Q\",\"title\":\"重庆大巴坠江瞬间视频曝光！初步核实：15人失联\"}],\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MzA3MzUzOTg1Nw==&amp;mid=2653696835&amp;idx=2&amp;sn=056eb5ca830eb6c269928b5c48993534&amp;chksm=84d51b3db3a2922b5450cb6e4d2a7e19cbfeca60cc3615b3aa94576504b4f4bb0362edbefbde&amp;mpshare=1&amp;scene=1&amp;srcid=1029mgzdbksMIfkTJaOTuQqR&amp;pass_ticket=gbvh10ZFq7WmkecRGgNLH0YS3mmtr6h332GEIE0nP4FXa4CtZyq6RYxpQFKEBFDq#rd\",\"subtype\":9,\"title\":\"坏爸爸！说好来接女儿，却迟迟不见身影！下一秒，泪目了\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540815263,\"fakeid\":\"2392014380\",\"id\":1000006743,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsGGU1xpDaopRXPUxnwHuWtjqOEczuNKOQPuNIjMy-rQAO8MuNboRXzw4*qKWLLRuCXlsrsk4Vq7s6DVTWa0Os-Q=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPgh8zibp8U9JfPibjCuP044fIWkT0CusXny3B30dm4qE84E7AxY4rD3ug/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"\",\"duration\":0,\"fileid\":518738187,\"is_multi\":0,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[],\"play_url\":\"\",\"source_url\":\"https://people.c.serviceh5.com/share.html\",\"subtype\":9,\"title\":\"这40张照片，带我穿越时光遇见你\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540812892,\"fakeid\":\"2392014380\",\"id\":1000006742,\"status\":2,\"type\":49}},{\"app_msg_ext_info\":{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsBiEgxkCbquVNDBw25d9r*qtVWbjNYUxH-QveKDlvmwZA0JNESnmV2sUik8QQphpr1wP9yDsgBNOrwfF7siOB2M=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPocKBNOs6MqicOcLBafS0QSvYs4TaibLFLCh0rDOPLnibg8Pibh03XlOGpA/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"给好人老吕点赞！\",\"duration\":0,\"fileid\":518738096,\"is_multi\":1,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"multi_app_msg_item_list\":[{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsBiEgxkCbquVNDBw25d9r*oC1eOOU7wm-tVgPHjaWTtjkpziAc7KGU*A1*4rzmzIH-alRdE--tfVtfWwxrUeP9g=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPFxQicD3Pelt6ibLuYtcRJjAHdibIqjt1J2UyaOX4KeZ4WvW73nEdeQMHw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"家长一定要警惕！\",\"duration\":0,\"fileid\":518738089,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MjM5NzkwNTA5Mg==&amp;mid=2651868336&amp;idx=1&amp;sn=a826dd9d971ff0a65b25e3f5a9ddbf81&amp;chksm=bd363b1b8a41b20dfbb9b5ffc1dba66d296c3307405e68ae69cc1bb5e1909fc7ad114b8ba12c&amp;mpshare=1&amp;scene=1&amp;srcid=10290u9rGjLxzathbujs2Tqg&amp;pass_ticket=nHOSbUtQTmyE%2B78VLYpyxK3%2B2U%2BV3AocSNcMRkLvvwP0PLRA3jB%2BB5wpcTn1aA2n#rd\",\"title\":\"【提醒】这款玩具含致命毒硼砂！对孩子，任何失误我们都承担不起\"},{\"audio_fileid\":0,\"author\":\"\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsBiEgxkCbquVNDBw25d9r*rx6C0AWKb-bkMfvkN5MRaNFyh-5APOBxnDUj7172OIDbe0PyJYzrI43mQgtsannfU=\",\"copyright_stat\":100,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IPDN2pvc4ia1um3t91XU3T7VmrG8e2zz1W6PwpC6uHM1yszTlYHM3Idkg/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"有用的知识要记牢！\",\"duration\":0,\"fileid\":518738091,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s/6O6k7kAdRCtruP7FTwtQyQ\",\"title\":\"【健康】这种病进入高发期！我国每21秒就有1人因它死亡\"},{\"audio_fileid\":0,\"author\":\"陈锴凯 杨一凡\",\"content\":\"\",\"content_url\":\"/s?timestamp=1540887258&amp;src=3&amp;ver=1&amp;signature=ysFzl4bM*PNMMoPKCbw9YlfSp8VAAH6EhpxyTcHpxmCzwKDswiC1fc6KE5VU0WQRN5CR0k4TZk8y7TD0uSBpsBiEgxkCbquVNDBw25d9r*qzdQZgW6sRD7maovN8rwpxWukaqSq-FkZM*B3*w-99hi6wxW0n8UCpg9OHgRy7H-w=\",\"copyright_stat\":101,\"cover\":\"http://mmbiz.qpic.cn/mmbiz_jpg/xrFYciaHL08CeqkZ6Ptb1BUW9gAvBs0IP1VVxlibiaaQibuJ372YRzyOasZmiad5yxicQicmWOaiaWc4Zp2kVoB6bQ0RQw/0?wx_fmt=jpeg\",\"del_flag\":1,\"digest\":\"你怎么看？\",\"duration\":0,\"fileid\":518738094,\"item_show_type\":0,\"malicious_content_type\":0,\"malicious_title_reason_id\":0,\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MTIxMjEzMzc0MQ==&amp;mid=2671625544&amp;idx=1&amp;sn=6dd4e5e1ae1622f2f3e96a731e097d0b&amp;chksm=7ac9234a4dbeaa5cbbc446cd83c174f14492019d5d3a7b433afc273c831810582cfa8895e041&amp;scene=21#wechat_redirect\",\"title\":\"【荐读】老大妈正乞讨，火车站循环广播：她家庭条件优越…家底曝光\"}],\"play_url\":\"\",\"source_url\":\"https://mp.weixin.qq.com/s?__biz=MTI0MDU3NDYwMQ==&amp;mid=2656708673&amp;idx=1&amp;sn=9fce48deab4d1651c25ced1509444266&amp;chksm=7a60d5a74d175cb13880a5520c6d6fbdf1225a4cb2915f7655be4a0901b588f20fca5314b344&amp;mpshare=1&amp;scene=1&amp;srcid=1029AR31iRKK86yGujlxiH8i&amp;pass_ticket=nHOSbUtQTmyE%2B78VLYpyxK3%2B2U%2BV3AocSNcMRkLvvwP0PLRA3jB%2BB5wpcTn1aA2n#rd\",\"subtype\":9,\"title\":\"他是批发鸡蛋的摊主，面对持刀乱刺的歹徒冲了上去，只因“我离得近”！\"},\"comm_msg_info\":{\"content\":\"\",\"datetime\":1540805280,\"fakeid\":\"2392014380\",\"id\":1000006741,\"status\":2,\"type\":49}}]";

//       json = "[{'app_msg_ext_info':{'title': '标题'}}]";
        List<WechatNewsBo> wechatNewsBos = JSONArray.parseArray(json, WechatNewsBo.class);

        System.out.println(wechatNewsBos);
    }
}
