package com.bxm.spider.deal.timer.job.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * <p> 招聘数据同步常量类 </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/11/27
 */
public class RecruitConstant {
    // 区域
    public static final Map<String,String> REGION_MAP = new HashMap<>();
    static {
        REGION_MAP.put("广德","宣城市");
        REGION_MAP.put("富阳","杭州市");
        REGION_MAP.put("杭州","杭州市");
    }

    //工资分隔符
    public static final  String[]            SALARY_PLACE_BEFORE = {"元.*?$","以.*?$","左.*?$"};
    public static final  String[]            SALARY_SPLIT        = {"—","――","-","至","~","--"};
    public static final  String              SALARY_PLACE_AFTER  = "\\+";
    public static final  String              SALARY              = "面议";
    public static final  String              SALARY_YISHANG      = "以上";
    public static final  int              SALARY_MAX     = 5000;
    public static final Map<String,String> SALARY_MAP          = new HashMap<>();
    static {
        SALARY_MAP.put("万","0000");
        SALARY_MAP.put("千","000");
    }
    //性别判断
    public static final  String              SEX_MAN             = "男";
    public static final  String              SEX_WOMAN           = "女";
    //年龄分隔符
    public static final  String              AGE_SPLIT1          = "——";
    public static final  String              AGE_SPLIT2          = "-";
    public static final  Integer             AGE_MIN             = 20;
    public static final  Integer             AGE_MAX             = 45;
    //获取招聘人数替换符
    public static final  String              PEOPLE_NUM          = "人.*?$";
    public static final  int                 PEOPLE_NUM_DEFAULT  = 1;
    //默认招聘方式
    public static final  int                 HIRE_MODEL_DEFAULT  = 1;
    //结束时间大于开始时间天数
    public static final int END_TIME_DEFAULT = 14;
    //企业规模单位
    public static final String COMPANY_SCALE = "人";
}
