package com.bxm.spider.deal.timer.job.utils;

import com.alibaba.fastjson.JSONObject;
import okhttp3.*;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * <p></p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2018/11/26
 */
public class HttpUtil {
    private static Logger        logger        = LoggerFactory.getLogger(HttpUtil.class);
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();

    // 创建一个 OkHttpClient
    private static final OkHttpClient mOkHttpClient = new OkHttpClient.Builder().connectTimeout(10,TimeUnit.SECONDS).readTimeout(10,TimeUnit.SECONDS).build();

    public static JSONObject httpPost(String url, String strParam) {
        // post请求返回结果
        CloseableHttpClient httpClient = HttpClients.createDefault();
        JSONObject jsonResult = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        try {
            if (null != strParam) {
                // 解决中文乱码问题
                StringEntity entity = new StringEntity(strParam, "utf-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity(entity);
            }
            CloseableHttpResponse result = httpClient.execute(httpPost);
            // 请求发送成功，并得到响应
            jsonResult = getJsonResult(result, url);
        } catch (IOException e) {
            logger.error("post请求提交失败:" + url, e);
        } finally {
            httpPost.releaseConnection();
        }
        return jsonResult;
    }

    private static JSONObject getJsonResult(CloseableHttpResponse result, String url){
        JSONObject jsonResult = null;
        if (result.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
            String str = "";
            try {
                // 读取服务器返回过来的json字符串数据
                str = EntityUtils.toString(result.getEntity(), "utf-8");
                // 把json字符串转换成json对象
                jsonResult = JSONObject.parseObject(str);
            } catch (Exception e) {
                logger.error("post请求提交失败:" + url, e);
            }
        }
        return jsonResult;
    }

    public static String okHttpPost(String url, String params){
        RequestBody body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), params);
        Request request = new Request.Builder().url(url).post(body).build();
        Response response = null;
        try {
            response = mOkHttpClient.newCall(request).execute();
            return response.body().string();
        } catch (IOException e) {
            logger.error("post请求提交失败,url:{},params:{}" + url,params, e);
        }
        return "";
    }
    public static String okHttpPost(String url, Map<String, Object> params){
        FormBody.Builder build = new FormBody.Builder();
        String result = "";
        try {
            for (String key : params.keySet()) {
                if (params.get(key) != null) {
                    build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
                }
            }
            RequestBody body = build.build();
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = null;
            response = mOkHttpClient.newCall(request).execute();
            result = response.body().string();
        } catch (IOException e) {
            logger.error("post请求提交失败,url:{},params:{}" + url,params, e);
        }
        return result;
    }
}
