package com.bxm.spider.download.facade.model;


import com.bxm.spider.constant.processor.PretreatmentEnum;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.constant.proxy.ProxyFlagEnum;

import java.io.Serializable;
import java.util.List;

/**
 * 下载任务Model
 *
 * @ClassName DownloadDto
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2018/10/22 17:11
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2018/10/22 17:11
 **/
public class DownloadDto implements Serializable {

    private String referer;

    private String channel;

    private String cookie;

    private String userAgent;
    /**
     * 是否使用代理
     */
    private ProxyFlagEnum proxyFlag;

    /**
     * 下载对象预处理类型
     */
    private PretreatmentEnum pretreatmentEnum;

    /**
     * 下载对象预处理参数
     */
    private String pretreatmentParam;

    /**
     * 编码
     */
    private String charset;

    /**
     * 公共参数
     */
    private ProcessorParameter processorParameter;

    /**
     * 登录账户列表
     */
    private List<LoginAccountDto> loginAccountDtoList;
    /**
     * 是否下载html：如果为false,pageInfo 则写入流水号
     */
    private Boolean isDownload;

    public Boolean getIsDownload() {
        return isDownload;
    }

    public void setIsDownload(Boolean download) {
        isDownload = download;
    }

    public List<LoginAccountDto> getLoginAccountDtoList() {
        return loginAccountDtoList;
    }

    public void setLoginAccountDtoList(List<LoginAccountDto> loginAccountDtoList) {
        this.loginAccountDtoList = loginAccountDtoList;
    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public PretreatmentEnum getPretreatmentEnum() {
        return pretreatmentEnum;
    }

    public void setPretreatmentEnum(PretreatmentEnum pretreatmentEnum) {
        this.pretreatmentEnum = pretreatmentEnum;
    }

    public String getPretreatmentParam() {
        return pretreatmentParam;
    }

    public void setPretreatmentParam(String pretreatmentParam) {
        this.pretreatmentParam = pretreatmentParam;
    }

    public ProcessorParameter getProcessorParameter() {
        return processorParameter;
    }

    public void setProcessorParameter(ProcessorParameter processorParameter) {
        this.processorParameter = processorParameter;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getCookie() {
        return cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public ProxyFlagEnum getProxyFlag() {
        return proxyFlag;
    }

    public void setProxyFlag(ProxyFlagEnum proxyFlag) {
        this.proxyFlag = proxyFlag;
    }


    @Override
    public String toString() {
        return "DownloadDto{" +
                "referer='" + referer + '\'' +
                ", channel='" + channel + '\'' +
                ", cookie='" + cookie + '\'' +
                ", userAgent='" + userAgent + '\'' +
                ", proxyFlag=" + proxyFlag +
                ", pretreatmentEnum=" + pretreatmentEnum +
                ", pretreatmentParam='" + pretreatmentParam + '\'' +
                ", charset='" + charset + '\'' +
                ", processorParameter=" + processorParameter +
                ", loginAccountDtoList=" + loginAccountDtoList +
                ", isDownload=" + isDownload +
                '}';
    }
}
