package com.bxm.spider.download.facade.service;

import com.bxm.spider.download.facade.model.DownloadDto;
import com.bxm.spider.response.ResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @ClassName DownloadFeignService
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author zhaox
 * @Date 2018/10/22 17:26
 * @Version 1.0.0
 * @Modifier zhaox
 * @Modify Date 2018/10/22 17:26
 **/
@FeignClient(name = "download-service")
public interface DownloadFeignService {

    /**
     * 下载
     *
     * @param downloadDto
     * @return boolean
     */
    @RequestMapping(value = "/download/download", method = RequestMethod.POST)
    ResponseModel<Boolean> download(@RequestBody DownloadDto downloadDto);

    /**
     * 单页下载
     * @param url
     * @return
     */
    @RequestMapping(value = "/download/pageDownload", method = RequestMethod.POST)
    ResponseModel<String> pageDownload(@RequestParam("url") String url,@RequestParam("isProxy") boolean isProxy);
}
