/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.spider.download.integration.impl;

import com.bxm.spider.constant.monitor.ErrorEnum;
import com.bxm.spider.constant.monitor.MonitorConstant;
import com.bxm.spider.constant.monitor.MonitorHelper;
import com.bxm.spider.constant.processor.ProcessorParameter;
import com.bxm.spider.deal.facade.model.DealDto;
import com.bxm.spider.deal.facade.service.ProcessorFacadeService;
import com.bxm.spider.download.facade.model.DownloadDto;
import com.bxm.spider.download.integration.DealIntegrationService;
import com.bxm.spider.response.ResponseModel;
import com.bxm.spider.response.ResponseModelFactory;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DealIntegrationServiceImpl
implements DealIntegrationService {
    @Autowired
    ProcessorFacadeService processorFacadeService;
    private static final Logger LOG = LoggerFactory.getLogger(DealIntegrationServiceImpl.class);

    @Override
    public Boolean dealContent(DownloadDto downloadDto, String content) {
        block5: {
            ResponseModel responseModel = ResponseModelFactory.FAILED();
            DealDto dealDto = this.convertToDealDto(downloadDto, content, null);
            try {
                responseModel = this.processorFacadeService.processor(dealDto);
                LOG.info("\u3010\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u6210\u529f\u3011,response data is {}", responseModel.getData());
            }
            catch (Exception e) {
                LOG.error("\u3010\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u5931\u8d25\u3011\uff01{}", (Object)downloadDto, (Object)e);
                for (int i = 0; i < 3; ++i) {
                    try {
                        responseModel = this.processorFacadeService.processor(dealDto);
                        if (!responseModel.isSuccess()) continue;
                        break;
                    }
                    catch (Exception e1) {
                        LOG.error("\u91cd\u8bd5\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u5931\u8d25{}\u6b21\uff01data: {}, message: {}", new Object[]{i, dealDto, e1.getMessage()});
                    }
                }
                if (!responseModel.isError()) break block5;
                LOG.error(MonitorConstant.MONITOR, "\u91cd\u8bd5\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u5931\u8d25\uff01data: {}, {}", new Object[]{dealDto, MonitorHelper.ofFailLog((String)"DOWNLOAD_PROGRESS", (ProcessorParameter)downloadDto.getProcessorParameter(), (ErrorEnum)ErrorEnum.DOWNLOAD_DEAL_ERROR, (String)e.getMessage()), e});
                return false;
            }
        }
        return true;
    }

    @Override
    public Boolean dealImage(DownloadDto downloadDto, String imageStr) {
        block5: {
            ResponseModel responseModel = ResponseModelFactory.FAILED();
            DealDto dealDto = this.convertToDealDto(downloadDto, null, imageStr);
            try {
                responseModel = this.processorFacadeService.imageProcessor(dealDto);
                LOG.info("\u3010\u56fe\u7247\u4e0b\u8f7d\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u6210\u529f\u3011,response data is {}", responseModel.getData());
            }
            catch (Exception e) {
                LOG.error("\u3010\u56fe\u7247\u4e0b\u8f7d\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u5931\u8d25\u3011{}", (Object)dealDto, (Object)e);
                for (int i = 0; i < 3; ++i) {
                    try {
                        responseModel = this.processorFacadeService.imageProcessor(dealDto);
                        if (!responseModel.isSuccess()) continue;
                        break;
                    }
                    catch (Exception e1) {
                        LOG.error("\u91cd\u8bd5\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u5931\u8d25{}\u6b21\uff01data: {}, message: {}", new Object[]{i, dealDto, e1.getMessage()});
                    }
                }
                if (!responseModel.isError()) break block5;
                LOG.error("\u91cd\u8bd5\u8c03\u7528\u5904\u7406\u4e2d\u5fc3\u5931\u8d25\uff01data: {}", (Object)dealDto, (Object)e);
                return false;
            }
        }
        return true;
    }

    private DealDto convertToDealDto(DownloadDto downloadDto, String pageInfo, String imageStr) {
        DealDto dealDto = new DealDto();
        if (StringUtils.isNotBlank((CharSequence)imageStr)) {
            dealDto.setImageStr(imageStr);
        }
        if (StringUtils.isNotBlank((CharSequence)pageInfo)) {
            dealDto.setPageInfo(pageInfo.replaceAll("\n|\t|\r", " "));
        }
        if (Objects.nonNull(downloadDto)) {
            dealDto.setProcessorParameter(downloadDto.getProcessorParameter());
        }
        return dealDto;
    }
}

